% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{plotspmmod}
\alias{plotspmmod}
\title{plotspmmod plots an spm model fit given parameters and data}
\usage{
plotspmmod(
  inp,
  indat,
  schaefer = TRUE,
  limit = 0.2,
  target = 0.48,
  addrmse = FALSE,
  fnt = 7,
  plotout = TRUE,
  vline = 0,
  plotprod = FALSE,
  maxy = 0
)
}
\arguments{
\item{inp}{a vector of model parameters at least (r,K,B0)}

\item{indat}{a matrix with at least columns 'year', 'catch', and 'cpue'}

\item{schaefer}{if TRUE, the default, then the Schaefer SPM is used. 
If FALSE then an approximate Fox SPM would be used}

\item{limit}{defaults to the Commonwealth limit of 0.2B0.}

\item{target}{defaults to the Commonwealth target of 0.48B0. Determines
the green line plotted on the exploitable biomass plot.}

\item{addrmse}{default is FALSE but if set TRUE this will add the loess
curve to the CPUE trend for comparison with the fitted line}

\item{fnt}{the font used in the plot and axes. Default=7, bold Times. 
Using 6 gives Times, 1 will give SansSerif, 2 = bold Sans}

\item{plotout}{should one generate a plot or only do the calculations; 
default is TRUE}

\item{vline}{defaults to 0 = no action but if a year is inserted,
which should generally be between two years to designate some
change in the time-series between two years, then a vertical line
will be added on year-based plots}

\item{plotprod}{if FALSE, the default, the productivity curves are 
not plotted. If TRUE, two extra plots are produced.}

\item{maxy}{defaults to 0, if > 0 then that value will be used in the
plot of CPUE}
}
\value{
invisibly a list of dynamics, production curve, MSY, and Bmsy
}
\description{
plotspmmod takes a parameter set and the spmdat matrix
    and plots the predicted depletion, catch, the CPUE and the model 
    fit to CPUE. If plotprod=TRUE, it also plots the productivity curves
}
\examples{
data(dataspm)
pars <- log(c(0.264,4740,3064,0.2))
ans <- plotspmmod(pars,dataspm,schaefer=TRUE,plotprod=TRUE)
best <- nlm(negLL,pars,funk=simpspm,indat=dataspm,
       logobs=log(dataspm[,"cpue"]),steptol=1e-05)
outfit(best,backtran = TRUE)
ans <- plotspmmod(best$estimate,dataspm,schaefer=TRUE,plotout=TRUE,
                 plotprod=FALSE,addrmse=TRUE)
str(ans)
}
