% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableHead.R
\name{tableHead}
\alias{tableHead}
\title{First Rows}
\usage{
tableHead(channel, sqtable, n = 3)
}
\arguments{
\item{channel}{an RODBC connection.}

\item{sqtable}{a database table or view.}

\item{n}{number of rows to get.}
}
\value{
Data frame with the first \code{n} rows of the database table or view.
}
\description{
Return the first rows of a database table.
}
\note{
This function can be used to examine the structure of a table or view, along
with some example data values.
}
\examples{
\dontrun{
con <- odbcConnect("myDatabase")

tableHead(con, "sysusers")

t(tableHead(con, "sysusers", 1))
}

}
\seealso{
\code{\link[RODBC]{sqlQuery}} with \code{\link{tableQuote}} are the
underlying functions used to query the table/view.

\code{\link{head}} is the base function to return the first parts of an
object inside the R workspace.

\code{\link{tableOverview}} shows the data types and dimensions of a database
table.

\code{\link{MSSQL-package}} gives an overview of the package.
}
