% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cPASS.R
\name{cPASS}
\alias{cPASS}
\title{cPASS}
\usage{
cPASS(datInput)
}
\arguments{
\item{datInput}{Data frame with column names: Experiment.id, Replicate, Bait,
Prey, and count (i.e., prey count).}
}
\value{
Data frame containing bait-prey pairs with average peptide spectrum match (PSMs), total PSMs,
ratio total PSMs,Z-score,S-score,D-score and WD-score.
}
\description{
This function applies Comparative Proteomic Analysis Software Suite (CompPASS) model
to score instances (e.g., bait-prey interactions (BPIs) in the data.frame.
The CompPASS is a robust statistical scoring scheme for assigning confidence scores to bait-prey
interactions (Sowa et al., 2009).This function was based on the source code.
\url{https://github.com/dnusinow/cRomppass}
}
\examples{
data(SampleDatInput)
datScoring <- cPASS(SampleDatInput)
head(datScoring)
}
\references{
Huttlin, E. L., Ting, L., Bruckner, R. J., Gebreab, F., Gygi, M. P., Szpyt, J., et al. (2015).
The BioPlex Network: A Systematic Exploration of the Human Interactome. Cell 162, 425-440.

Sowa, M. E., Bennett, E. J., Gygi, S. P., and Harper, J. W. (2009).
Defining the human deubiquitinating enzyme interaction landscape. Cell 138, 389-403.
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
