% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearZeroVar.R
\name{nearZeroVar}
\alias{nearZeroVar}
\title{Identify variables with near zero variance}
\usage{
nearZeroVar(x, freqCut = 95/5, uniqueCut = 10)
}
\arguments{
\item{x}{a numeric vector or matrix, or a data frame with all numeric data.}

\item{freqCut}{the cutoff for the ratio of the most common value to the second most common value.}

\item{uniqueCut}{the cutoff for the percentage of distinct values out of the number of total samples.}
}
\value{
nzv object
}
\description{
Adapted and stripped down from mixOmics v 5.2.0 (https://cran.r-project.org/web/packages/mixOmics/).
}
\examples{
data("freelive2")
nearZeroVar(XRVIP2)
data("mosquito")
nearZeroVar(Xotu)
}
