% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/dummyManagedProvider.R,
%   R/method-default.R
\name{getDockerWorkerStatus}
\alias{getDockerWorkerStatus}
\alias{IsDockerWorkerInitializing}
\alias{IsDockerWorkerRunning}
\alias{IsDockerWorkerStopped}
\alias{getDockerWorkerStatus,DummyManagedProvider-method}
\alias{IsDockerWorkerInitializing,ANY-method}
\alias{IsDockerWorkerRunning,ANY-method}
\alias{IsDockerWorkerStopped,ANY-method}
\title{Get the worker status}
\usage{
getDockerWorkerStatus(provider, cluster, workerHandles, verbose)

IsDockerWorkerInitializing(provider, cluster, workerHandles, verbose)

IsDockerWorkerRunning(provider, cluster, workerHandles, verbose)

IsDockerWorkerStopped(provider, cluster, workerHandles, verbose)

\S4method{getDockerWorkerStatus}{DummyManagedProvider}(provider, cluster, workerHandles, verbose)

\S4method{IsDockerWorkerInitializing}{ANY}(provider, cluster, workerHandles, verbose = 0L)

\S4method{IsDockerWorkerRunning}{ANY}(provider, cluster, workerHandles, verbose = 0L)

\S4method{IsDockerWorkerStopped}{ANY}(provider, cluster, workerHandles, verbose = 0L)
}
\arguments{
\item{provider}{S4 \code{CloudProvider} object. The service provider.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{workerHandles}{Character(n). A character vector of \strong{unique} instance handles.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
\code{getDockerWorkerStatus} : A character vector with each element corresponding
to an instance in \code{workerHandles}. Each element must be one of three possible characters
\code{"initializing"}, \code{"running"} or \code{"stopped"}

\code{IsDockerWorkerInitializing}, \code{IsDockerWorkerRunning}, \code{IsDockerWorkerStopped}:
A logical vector with each element corresponding to the status of each instance
}
\description{
Get the worker status. Unless you have a faster implementation, you only need to
define \code{getDockerWorkerStatus}. The function should return a character vector with
each element corresponding to a worker in \code{workerHandles}.
Each element must be one of three possible characters \code{"initializing"}, \code{"running"} or
\code{"stopped"}. There is no default method for \code{getDockerWorkerStatus}.
}
\section{Functions}{
\itemize{
\item \code{getDockerWorkerStatus,DummyManagedProvider-method}: The method for the dummy managed provider
}}

