% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.mle_0.1.1.R
\name{survival.mle}
\alias{survival.mle}
\title{Maximum likelihood estimation under parametric survival function}
\usage{
survival.mle(
t.event,
event,
distribution = c("exponential", "weibull", "gamma", "log-normal", "burr3"),
par = c(0,0))
}
\arguments{
\item{t.event}{a vector for time-to-event.}

\item{event}{a vector for event indicator.}

\item{distribution}{a parametric distribution for survival function. Available options include; "exponential", "weibull", "gamma", "log-normal", "burr3".}

\item{par}{initial value(s) for the distribution parameters.}
}
\value{
estimate: a vector of MLE.

var: variance-covariance matrix of MLE.

AIC: Akaike information criteria.

KS: Kolmogorov-Smirnov distance between MLE and KM estimator.
}
\description{
\code{survival.mle} provides the maximum likelihood estimator and their variance-covariance matrix under parametric survival functions. This function also provides AIC and Kolmogorov-Smirnov distance to evaluate the model fitting.
}
\examples{
#MLE under exponential distribution
#set distribution parameter
lambda = 1

#generate time to event
u = runif(100)
t.event = -log(u)/lambda
t.event = sort(t.event)

#censoring indicator
tc = runif(100, 0, 1.5)
t.event = (tc >= t.event) * t.event + (tc < t.event) * tc
event = 1 * (tc > t.event)

survival.mle(t.event, event, distribution = "exponential")



}
