% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allCorrelations.R
\name{allCorrelations}
\alias{allCorrelations}
\title{All correlations}
\usage{
allCorrelations(
  X1,
  X2,
  ncomp1,
  ncomp2,
  methods = c("SMI", "RV", "RV2", "RVadj", "PSI", "r1", "r2", "r3", "r4", "GCD"),
  digits = 3,
  plot = TRUE,
  xlab = "",
  ylab = "",
  ...
)
}
\arguments{
\item{X1}{first \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{X2}{second \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{ncomp1}{maximum number of subspace components from the first \code{matrix}.}

\item{ncomp2}{maximum number of subspace components from the second \code{matrix}.}

\item{methods}{\code{character} vector containing a subset of the supported methods: "SMI", "RV", "RV2", "RVadj", "PSI", "r1", "r2", "r3", "r4", "GCD".}

\item{digits}{number of digits for numerical output.}

\item{plot}{logical indicating if plotting should be performed (default = TRUE).}

\item{xlab}{optional x axis label.}

\item{ylab}{optional y axis label.}

\item{...}{additional arguments for \code{SMI} or \code{plot}.}
}
\value{
A single value measuring the similarity of two matrices.
}
\description{
Compare all correlation measures in the package (or a subset)
}
\details{
For each of the coefficients a single scalar is computed to describe
the similarity between the two input matrices. Note that some methods requires setting
one or two numbers of components.
}
\examples{
X1  <- scale( matrix( rnorm(100*300), 100,300), scale = FALSE)
usv <- svd(X1)
# Remove third principal component from X1 to produce X2
X2  <- usv$u[,-3] \%*\% diag(usv$d[-3]) \%*\% t(usv$v[,-3])

allCorrelations(X1,X2, ncomp1 = 5,ncomp2 = 5)

}
\references{
\describe{
 \item{SMI:}{ Indahl, U.G.; Næs, T.; Liland, K.H.; 2018. A similarity index for comparing coupled matrices. Journal of Chemometrics; e3049.}
 \item{RV:}{ Robert, P.; Escoufier, Y. (1976). "A Unifying Tool for Linear Multivariate
  Statistical Methods: The RV-Coefficient". Applied Statistics 25 (3): 257-265.}
 \item{RV2:}{ Smilde, AK; Kiers, HA; Bijlsma, S; Rubingh, CM; van Erk, MJ (2009). "Matrix correlations
 for high-dimensional data: the modified RV-coefficient". Bioinformatics 25(3): 401-5.}
 \item{Adjusted RV:}{ Mayer, CD; Lorent, J; Horgan, GW. (2011). "Exploratory analysis of multiple omics
 datasets using the adjusted RV coefficient". Stat Appl Genet Mol Biol. 10(14).}
 \item{PSI:}{ Sibson, R; 1978. "Studies in the Robustness of Multidimensional Scaling:
 Procrustes Statistics". Journal of the Royal Statistical Society. Series B (Methodological), Vol. 40, No. 2, pp. 234-238.}
 \item{Rozeboom:}{ Rozeboom, WW; 1965. "Linear correlations between sets of variables".
 Psychometrika 30(1): 57-71.}
 \item{Coxhead:}{ Coxhead, P; 1974. "Measuring the releationship between two sets of variables". British Journal of
 Mathematical and Statistical Psychology 27: 205-212.}
}
}
\seealso{
\code{\link{SMI}}, \code{\link{RV}} (RV2/RVadj), \code{\link{r1}} (r2/r3/r4/GCD).
}
\author{
Kristian Hovde Liland
}
