% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSData.R
\name{MSData}
\alias{MSData}
\title{Generate Artificial Metabolic Survival Data}
\usage{
MSData(nPatients = 100, nMet = 150, Prop = 0.5)
}
\arguments{
\item{nPatients}{The number of patients}

\item{nMet}{The number of metabolites}

\item{Prop}{The proportion of patients having low risk}
}
\value{
An object of class list is returned with the following items .
\item{Censor}{The censoring/event indicator}
\item{Survival}{The Survival time}
\item{Met.names}{The vector of metabolites name}
\item{Mdata}{The metabolic profile matrix}
\item{Prognostic}{A data frame with prognostic factors.}
}
\description{
The Function generates metabolic profile and survival dataset of any number of patients and also their survival information.
}
\details{
The function generates the metabolic profile where small set of metabolites (30) are informative and rest of them are set as noisy metabolites.
Also, the survival time and Censoring information are generated based on first right singular vectors of \code{\link[base]{svd}} of the metabolic profile matrix.
It also generates other prognostic factors such as Age, Stage and Gender which are slightly correlated with survival time.
}
\examples{
#GENERATE SOME METABOLIC SURVIVAL DATA WITH PROGNOSTIC FACTORS

Data<-MSData(nPatients=100,nMet=150,Prop=0.5)

SurvTime<-Data$Survival
Censor<-Data$Censor
ProgFact<-Data$Prognostic
MetData<-Data$Mdata
Metnames<-Data$Met.names
}
\seealso{
\code{\link[survival]{coxph}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
