% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetabolicSurvClass.R
\docType{class}
\name{cvle-class}
\alias{cvle-class}
\title{The cvle Class.}
\description{
The cvle Class.
}
\section{Slots}{

\describe{
\item{\code{Coef.mat}}{A matrix of coefficients with rows equals to number of
cross validations and columns equals to number of metabolites.}

\item{\code{Runtime}}{A vector of runtime for each iteration measured in seconds.}

\item{\code{lambda}}{A vector of estimated optimum lambda for each iterations.}

\item{\code{n}}{A vector of the number of selected metabolites}

\item{\code{Met.mat}}{A matrix with 0 and 1. Number of rows equals to number of
iterations and number of columns equals to number of metabolites.
1 indicates that the particular metabolite was selected or had
nonzero coefficient and otherwise it is zero.}

\item{\code{HRTrain}}{A matrix of survival information for the training
dataset. It has three columns representing the estimated HR,
the 95\% lower confidence interval and the 95\% upper confidence interval.}

\item{\code{HRTest}}{A matrix of survival information for the test dataset.
It has three columns representing the estimated HR, the 95\% lower
confidence interval and the 95\% upper confidence interval.}

\item{\code{pld}}{A vector of partial likelihood deviance at each
cross validations.}

\item{\code{Mdata}}{The metabolite matrix that was used for the analysis
which can either be the full the full data or a reduced
supervised PCA version.}
}}

\examples{
\donttest{
## GENERATE SOME METABOLIC SURVIVAL DATA WITH PROGNOSTIC FACTORS
Data<-MSData(nPatients=100,nMet=150,Prop=0.5)

## USE THE FUNCTION
Eg = CVLasoelacox(Survival = Data$Survival,Censor = Data$Censor,
Mdata = t(Data$Mdata),Prognostic = Data$Prognostic, Quantile = 0.5,
Metlist = NULL,Standardize = TRUE, Reduce=FALSE, Select=15,
Alpha = 1,Fold = 4,Ncv = 10,nlambda = 100)

## GET THE CLASS OF THE OBJECT
class(Eg)     # An "cvle" Class

##  METHOD THAT CAN BE USED FOR THIS CLASS
show(Eg)
summary(Eg)
plot(Eg, type =3)
}
}
\seealso{
\code{\link[MetabolicSurv]{EstimateHR}}, \code{\link[glmnet]{glmnet}}, \code{\link[MetabolicSurv]{Lasoelacox}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
