% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acide.R
\name{Acid}
\alias{Acid}
\title{Acid}
\usage{
Acid(alpha, MIC, concentration = 1)
}
\arguments{
\item{alpha}{sensitivity.}

\item{MIC}{concentration minimale d'inhibition.}

\item{concentration}{acid concentration (in g/L).}
}
\value{
the acid modeled with the following accessible attributes:
\item{alpha}{the \code{alpha} value or list of values.}
\item{MIC}{the \code{MIC} value or list of values.}
\item{concentration}{the acid concentration (in g/L).}
\item{getCoefMin}{function returning the minimum coefficient to apply to a MicrobialGrowth-object (see details section).}
\item{getCoefMid}{function returning the "middle" coefficient to apply to a MicrobialGrowth-object (see details section).}
\item{getCoefMax}{function returning the maximum coefficient to apply to a MicrobialGrowth-object (see details section).}
}
\description{
Modeling of an acid with \code{alpha} its sensitivity and \code{MIC} its minimum inhibition concentration.
The default \code{concentration} is 1g/L.
}
\details{
The arguments \code{alpha} and \code{MIC} can be given as one to three values.

A single value means that \code{getCoefMin}, \code{getCoefMid} and \code{getCoefMax} will return the same coefficient.

Two values symbolize some sort of uncertainty about \code{alpha} and/or \code{MIC}.
The functions \code{getCoefMin} and \code{getCoefMax} will use the pair (alpha, MIC) which respectively minimizes and maximizes the coefficients.
The \code{getCoefMid} function will return a coefficient based on the average of the values entered.

Three values act as for two values except that for the function \code{getCoefMid} will use this third value (middle value) for the calculation of the coefficient.

Please note, entering several values acts as a pool of available values, and not as pairs (alpha, MIC).
For example, the \code{getCoefMin} function will use the minimum value \code{alpha} and the minimum value \code{MIC}.
If you wish to specify pairs (alpha, MIC), see \link{Acid.SpecificPair} which will determine, for example for \code{getCoefMin}, the pair (alpha, MIC) minimizing the coefficient.
}
\examples{
# Classic instantiation
aceticAcid <- Acid(1.245, 5.47)
print(aceticAcid)
## acid {alpha=1.245, MIC=5.47g/L, concentration=1g/L}

# Classic instantiation by specifying a concentration
print( Acid(1.245, 5.47, 3) )
## acid {alpha=1.245, MIC=5.47g/L, concentration=3g/L}

# Instantiation with multiple `alpha` and `MIC` values (see details section)
print( Acid(c(0.98, 1.1, 1.51), c(5.26, 5.68)) )
## acid {alpha=[0.98, 1.1, 1.51], MIC=[5.26, 5.68]g/L, concentration=1g/L}

# Generic operators (`+`, `*`, etc.) can change the `concentration` of the acid.
print(aceticAcid / 2)
## acid {alpha=1.245, MIC=5.47g/L, concentration=0.5g/L}
print(aceticAcid + 2)
## acid {alpha=1.245, MIC=5.47g/L, concentration=3g/L}

# Without having to pre-define specific concentrations, and with the default `concentration` (1g/L),
# you can dynamically change the acid concentration as follows:
for (concentration in c(0.5, 1, 5, 10)) {
  print(concentration * aceticAcid)
}
## acid {alpha=1.245, MIC=5.47g/L, concentration=0.5g/L}
## acid {alpha=1.245, MIC=5.47g/L, concentration=1g/L}
## acid {alpha=1.245, MIC=5.47g/L, concentration=5g/L}
## acid {alpha=1.245, MIC=5.47g/L, concentration=10g/L}

try({
  # Acid can be applied to a MicrobilogicalGrowth-object with the `+` addition operator.
  # Note that the acid should be on the right side, otherwise an error is raised.
  MyMicrobialGrowthObject + aceticAcid
  ## returns the MicrobialGrowth-object affected by the acid (several acids can be applied)
})
}
\seealso{
\link{Acid.SpecificPair}
}
