% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{gompertz.explain}
\alias{gompertz.explain}
\title{Graphical Example of Modified Gompertz Equation.}
\usage{
gompertz.explain(
  N0 = 0.14,
  Nmax = 1.43,
  mu = 0.07,
  lambda = 40,
  xlim = c(0, 100)
)
}
\arguments{
\item{N0}{initial population.}

\item{Nmax}{final/maximum population.}

\item{mu}{growth rate.}

\item{lambda}{latency time.}

\item{xlim}{range of values to simulate \code{x} and \code{y}.}
}
\value{
No return value, called to plot a MicrobialGrowth object with the Gompertz model to illustrate the different coefficients.
}
\description{
Graphical Example of Modified Gompertz Equation.
}
\examples{
gompertz.explain()

gompertz.explain(0.15, 2, 0.1, 40, c(0,100))
}
