% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_p.R
\name{select_p}
\alias{select_p}
\title{Data-driven selection of p  for the test of randomness}
\usage{
select_p(X, p0 = 2, d = 5, q = 2.4, lambda = 0.25)
}
\arguments{
\item{X}{Time series}

\item{p0}{Minimum value of p (default is 2)}

\item{d}{Maximum value of p (default is 5)}

\item{q}{Constant for selecting between AIC and BIC type penalty (default is 2.4)}

\item{lambda}{Penalty term (default is 0.25); small values lead to p=d, large value lead to p=p0}
}
\value{
\item{p}{Selected value of p}
}
\description{
This function uses a AIC/BIC type criterion to select p based on the data.
}
\examples{
X <- SimAR1Poisson(c(5,0.2),100)
out <- select_p(X)

}
\references{
B.R Nasri (2021). Tests of serial dependence for arbitrary distributions
}
