#' Symmetric Third Order Designs for sequential experimentation
#'
#' @param v Total number of input factors
#'
#' @return Third Order Design in two blocks along with G-efficiency
#'@description Generates symmetric sequential Third Order Design with v (3<=v<=9) factors in two blocks. Block I gives a second order design for the first stage of the experimentation. If lack of fit of the second order model is found to be significant, then further experimentation can be done with the design given in block II. Runs from block-I and block-II combined form a third order design. It also gives G-efficiency of the third order design.
#' @export
#'
#' @examples
#'library(MixedLevelRSDs)
#'SeqTORD(4)
#'@references
#'  1) G.E.P. Box and K.B. Wilson (1951). " On the experimental attainment of optimum conditions".
#'
#'  2) M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar Mandal (2022)<doi: 10.1080/03610926.2021.1944213>.
#'  "Theoretical developments in response surface designs: an informative review and further thoughts".
#'
#'  3) M. Hemavathi, Eldho Varghese, Shashi Shekhar & Seema Jaggi (2020) <doi: 10.1080/02664763.2020.1864817>. "Sequential asymmetric third order rotatable designs (SATORDs) ".


SeqTORD<-function(v){

  if(v==3){
    B1<-matrix(c(1	,	1	,	-1	,
                 1	,	-1	,	1	,
                 -1	,	1	,	1	,
                 -1	,	-1	,	-1	,
                 2	,	0	,	0	,
                 -2	,	0	,	0	,
                 0	,	2	,	0	,
                 0	,	-2	,	0	,
                 0	,	0	,	2	,
                 0	,	0	,	-2	,
                 0	,	0	,	0	,
                 0	,	0	,	0	,
                 0	,	0	,	0	),nrow=13,byrow=T)

    B2<-matrix(c(1	,	1	,	0	,
                 1	,	-1	,	0	,
                 -1	,	1	,	0	,
                 -1	,	-1	,	0	,
                 1	,	0	,	1	,
                 1	,	0	,	-1	,
                 -1	,	0	,	1	,
                 -1	,	0	,	-1	,
                 0	,	1	,	1	,
                 0	,	1	,	-1	,
                 0	,	-1	,	1	,
                 0	,	-1	,	-1	,
                 0	,	0	,	0	,
                 0	,	0	,	0	,
                 0	,	0	,	0	),nrow=15,byrow=T)

    # lm=list("Block 1"= B1, "Block 2"= B2)
    # return(lm)
  }
  if(v==4){
    B1<-matrix(c(1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,
                 1	,	-1	,	1	,	1	,
                 1	,	-1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	1	,	1	,
                 -1	,	1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	-1	,	-1	,
                 2	,	0	,	0	,	0	,
                 -2	,	0	,	0	,	0	,
                 0	,	2	,	0	,	0	,
                 0	,	-2	,	0	,	0	,
                 0	,	0	,	2	,	0	,
                 0	,	0	,	-2	,	0	,
                 0	,	0	,	0	,	2	,
                 0	,	0	,	0	,	-2	,
                 0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	),nrow=27,byrow=T)
    B2<-matrix(c(1	,	1	,	0	,	0	,
                 1	,	-1	,	0	,	0	,
                 -1	,	1	,	0	,	0	,
                 -1	,	-1	,	0	,	0	,
                 1	,	0	,	1	,	0	,
                 1	,	0	,	-1	,	0	,
                 -1	,	0	,	1	,	0	,
                 -1	,	0	,	-1	,	0	,
                 1	,	0	,	0	,	1	,
                 1	,	0	,	0	,	-1	,
                 -1	,	0	,	0	,	1	,
                 -1	,	0	,	0	,	-1	,
                 0	,	1	,	1	,	0	,
                 0	,	1	,	-1	,	0	,
                 0	,	-1	,	1	,	0	,
                 0	,	-1	,	-1	,	0	,
                 0	,	1	,	0	,	1	,
                 0	,	1	,	0	,	-1	,
                 0	,	-1	,	0	,	1	,
                 0	,	-1	,	0	,	-1	,
                 0	,	0	,	1	,	1	,
                 0	,	0	,	1	,	-1	,
                 0	,	0	,	-1	,	1	,
                 0	,	0	,	-1	,	-1	,
                 0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	),nrow=27,byrow=T)
    # lm=list("Block 1"=B1, "Block 2"=B2)
    # return(lm)
  }
  if(v==5){
    B1<-matrix(c(-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,
                 1	,	1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,
                 -1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,
                 1	,	-1	,	1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	-1	,
                 1	,	1	,	1	,	1	,	1	,
                 2	,	0	,	0	,	0	,	0	,
                 -2	,	0	,	0	,	0	,	0	,
                 0	,	2	,	0	,	0	,	0	,
                 0	,	-2	,	0	,	0	,	0	,
                 0	,	0	,	2	,	0	,	0	,
                 0	,	0	,	-2	,	0	,	0	,
                 0	,	0	,	0	,	2	,	0	,
                 0	,	0	,	0	,	-2	,	0	,
                 0	,	0	,	0	,	0	,	2	,
                 0	,	0	,	0	,	0	,	-2	,
                 0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	),nrow=30,byrow=T)
    B2<-matrix(c(1	,	1	,	0	,	0	,	0	,
                 1	,	-1	,	0	,	0	,	0	,
                 -1	,	1	,	0	,	0	,	0	,
                 -1	,	-1	,	0	,	0	,	0	,
                 1	,	0	,	1	,	0	,	0	,
                 1	,	0	,	-1	,	0	,	0	,
                 -1	,	0	,	1	,	0	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,
                 1	,	0	,	0	,	1	,	0	,
                 1	,	0	,	0	,	-1	,	0	,
                 -1	,	0	,	0	,	1	,	0	,
                 -1	,	0	,	0	,	-1	,	0	,
                 1	,	0	,	0	,	0	,	1	,
                 1	,	0	,	0	,	0	,	-1	,
                 -1	,	0	,	0	,	0	,	1	,
                 -1	,	0	,	0	,	0	,	-1	,
                 0	,	1	,	1	,	0	,	0	,
                 0	,	1	,	-1	,	0	,	0	,
                 0	,	-1	,	1	,	0	,	0	,
                 0	,	-1	,	-1	,	0	,	0	,
                 0	,	1	,	0	,	1	,	0	,
                 0	,	1	,	0	,	-1	,	0	,
                 0	,	-1	,	0	,	1	,	0	,
                 0	,	-1	,	0	,	-1	,	0	,
                 0	,	1	,	0	,	0	,	1	,
                 0	,	1	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	0	,	-1	,
                 0	,	0	,	1	,	1	,	0	,
                 0	,	0	,	1	,	-1	,	0	,
                 0	,	0	,	-1	,	1	,	0	,
                 0	,	0	,	-1	,	-1	,	0	,
                 0	,	0	,	1	,	0	,	1	,
                 0	,	0	,	1	,	0	,	-1	,
                 0	,	0	,	-1	,	0	,	1	,
                 0	,	0	,	-1	,	0	,	-1	,
                 0	,	0	,	0	,	1	,	1	,
                 0	,	0	,	0	,	1	,	-1	,
                 0	,	0	,	0	,	-1	,	1	,
                 0	,	0	,	0	,	-1	,	-1	,
                 0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	),nrow=43,byrow=T)
    # lm=list("Block 1"=B1, "Block 2"=B2)
    # return(lm)
  }
  if(v==6){
    B1<-matrix(c(-1	,	1	,	1	,	-1	,	1	,	1	,
                 -1	,	1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	1	,
                 1	,	-1	,	1	,	1	,	1	,	-1	,
                 -1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,	1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	1	,	-1	,
                 1	,	1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	1	,
                 1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 2.743977	,	0	,	0	,	0	,	0	,	0	,
                 -2.743977	,	0	,	0	,	0	,	0	,	0	,
                 0	,	2.743977	,	0	,	0	,	0	,	0	,
                 0	,	-2.743977	,	0	,	0	,	0	,	0	,
                 0	,	0	,	2.743977	,	0	,	0	,	0	,
                 0	,	0	,	-2.743977	,	0	,	0	,	0	,
                 0	,	0	,	0	,	2.743977	,	0	,	0	,
                 0	,	0	,	0	,	-2.743977	,	0	,	0	,
                 0	,	0	,	0	,	0	,	2.743977	,	0	,
                 0	,	0	,	0	,	0	,	-2.743977	,	0	,
                 0	,	0	,	0	,	0	,	0	,	2.743977	,
                 0	,	0	,	0	,	0	,	0	,	-2.743977	,
                 0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	),nrow=47,byrow=T)
    B2<-matrix(c(1	,	1	,	0	,	-1	,	0	,	0	,
                 -1	,	1	,	0	,	-1	,	0	,	0	,
                 -1	,	1	,	0	,	1	,	0	,	0	,
                 -1	,	-1	,	0	,	1	,	0	,	0	,
                 1	,	-1	,	0	,	-1	,	0	,	0	,
                 1	,	-1	,	0	,	1	,	0	,	0	,
                 1	,	1	,	0	,	1	,	0	,	0	,
                 -1	,	-1	,	0	,	-1	,	0	,	0	,
                 0	,	1	,	1	,	0	,	-1	,	0	,
                 0	,	-1	,	1	,	0	,	-1	,	0	,
                 0	,	-1	,	1	,	0	,	1	,	0	,
                 0	,	-1	,	-1	,	0	,	1	,	0	,
                 0	,	1	,	-1	,	0	,	-1	,	0	,
                 0	,	1	,	-1	,	0	,	1	,	0	,
                 0	,	1	,	1	,	0	,	1	,	0	,
                 0	,	-1	,	-1	,	0	,	-1	,	0	,
                 -1	,	0	,	1	,	1	,	0	,	0	,
                 -1	,	0	,	-1	,	1	,	0	,	0	,
                 1	,	0	,	-1	,	1	,	0	,	0	,
                 1	,	0	,	-1	,	-1	,	0	,	0	,
                 -1	,	0	,	1	,	-1	,	0	,	0	,
                 1	,	0	,	1	,	-1	,	0	,	0	,
                 1	,	0	,	1	,	1	,	0	,	0	,
                 -1	,	0	,	-1	,	-1	,	0	,	0	,
                 0	,	-1	,	0	,	1	,	1	,	0	,
                 0	,	-1	,	0	,	-1	,	1	,	0	,
                 0	,	1	,	0	,	-1	,	1	,	0	,
                 0	,	1	,	0	,	-1	,	-1	,	0	,
                 0	,	-1	,	0	,	1	,	-1	,	0	,
                 0	,	1	,	0	,	1	,	-1	,	0	,
                 0	,	1	,	0	,	1	,	1	,	0	,
                 0	,	-1	,	0	,	-1	,	-1	,	0	,
                 1	,	0	,	-1	,	0	,	1	,	0	,
                 1	,	0	,	-1	,	0	,	-1	,	0	,
                 1	,	0	,	1	,	0	,	-1	,	0	,
                 -1	,	0	,	1	,	0	,	-1	,	0	,
                 -1	,	0	,	-1	,	0	,	1	,	0	,
                 -1	,	0	,	1	,	0	,	1	,	0	,
                 1	,	0	,	1	,	0	,	1	,	0	,
                 -1	,	0	,	-1	,	0	,	-1	,	0	,
                 1	,	-1	,	0	,	0	,	0	,	1	,
                 1	,	-1	,	0	,	0	,	0	,	-1	,
                 1	,	1	,	0	,	0	,	0	,	-1	,
                 -1	,	1	,	0	,	0	,	0	,	-1	,
                 -1	,	-1	,	0	,	0	,	0	,	1	,
                 -1	,	1	,	0	,	0	,	0	,	1	,
                 1	,	1	,	0	,	0	,	0	,	1	,
                 -1	,	-1	,	0	,	0	,	0	,	-1	,
                 0	,	1	,	-1	,	0	,	0	,	1	,
                 0	,	1	,	-1	,	0	,	0	,	-1	,
                 0	,	1	,	1	,	0	,	0	,	-1	,
                 0	,	-1	,	1	,	0	,	0	,	-1	,
                 0	,	-1	,	-1	,	0	,	0	,	1	,
                 0	,	-1	,	1	,	0	,	0	,	1	,
                 0	,	1	,	1	,	0	,	0	,	1	,
                 0	,	-1	,	-1	,	0	,	0	,	-1	,
                 0	,	0	,	1	,	-1	,	0	,	1	,
                 0	,	0	,	1	,	-1	,	0	,	-1	,
                 0	,	0	,	1	,	1	,	0	,	-1	,
                 0	,	0	,	-1	,	1	,	0	,	-1	,
                 0	,	0	,	-1	,	-1	,	0	,	1	,
                 0	,	0	,	-1	,	1	,	0	,	1	,
                 0	,	0	,	1	,	1	,	0	,	1	,
                 0	,	0	,	-1	,	-1	,	0	,	-1	,
                 0	,	0	,	0	,	1	,	-1	,	1	,
                 0	,	0	,	0	,	1	,	-1	,	-1	,
                 0	,	0	,	0	,	1	,	1	,	-1	,
                 0	,	0	,	0	,	-1	,	1	,	-1	,
                 0	,	0	,	0	,	-1	,	-1	,	1	,
                 0	,	0	,	0	,	-1	,	1	,	1	,
                 0	,	0	,	0	,	1	,	1	,	1	,
                 0	,	0	,	0	,	-1	,	-1	,	-1	,
                 -1	,	0	,	0	,	0	,	1	,	1	,
                 -1	,	0	,	0	,	0	,	1	,	-1	,
                 1	,	0	,	0	,	0	,	1	,	-1	,
                 1	,	0	,	0	,	0	,	-1	,	-1	,
                 -1	,	0	,	0	,	0	,	-1	,	1	,
                 1	,	0	,	0	,	0	,	-1	,	1	,
                 1	,	0	,	0	,	0	,	1	,	1	,
                 -1	,	0	,	0	,	0	,	-1	,	-1	,
                 0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	),nrow=83,byrow=T)
    # lm=list("Block 1"=B1, "Block 2"=B2)
    # return(lm)
  }
  if(v==7){
    B1<-matrix(c(-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                 -1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                 -1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                 1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                 1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                 -1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                 -1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                 1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                 -1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                 1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                 2.64575131	,	0	,	0	,	0	,	0	,	0	,	0	,
                 -2.64575131	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	2.64575131	,	0	,	0	,	0	,	0	,	0	,
                 0	,	-2.64575131	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	2.64575131	,	0	,	0	,	0	,	0	,
                 0	,	0	,	-2.64575131	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	2.64575131	,	0	,	0	,	0	,
                 0	,	0	,	0	,	-2.64575131	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	2.64575131	,	0	,	0	,
                 0	,	0	,	0	,	0	,	-2.64575131	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	2.64575131	,	0	,
                 0	,	0	,	0	,	0	,	0	,	-2.64575131	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	2.64575131	,
                 0	,	0	,	0	,	0	,	0	,	0	,	-2.64575131	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=82,byrow=T)
    B2<-matrix(c(1	,	0	,	1	,	0	,	0	,	0	,	0	,
                 1	,	0	,	-1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,	0	,	0	,
                 0	,	0	,	1	,	0	,	0	,	1	,	0	,
                 0	,	0	,	1	,	0	,	0	,	-1	,	0	,
                 0	,	0	,	-1	,	0	,	0	,	1	,	0	,
                 0	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                 1	,	0	,	0	,	1	,	0	,	0	,	0	,
                 1	,	0	,	0	,	-1	,	0	,	0	,	0	,
                 -1	,	0	,	0	,	1	,	0	,	0	,	0	,
                 -1	,	0	,	0	,	-1	,	0	,	0	,	0	,
                 0	,	0	,	1	,	0	,	0	,	0	,	1	,
                 0	,	0	,	1	,	0	,	0	,	0	,	-1	,
                 0	,	0	,	-1	,	0	,	0	,	0	,	1	,
                 0	,	0	,	-1	,	0	,	0	,	0	,	-1	,
                 1	,	0	,	0	,	0	,	1	,	0	,	0	,
                 1	,	0	,	0	,	0	,	-1	,	0	,	0	,
                 -1	,	0	,	0	,	0	,	1	,	0	,	0	,
                 -1	,	0	,	0	,	0	,	-1	,	0	,	0	,
                 1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 -1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 -1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 0	,	0	,	0	,	1	,	0	,	0	,	1	,
                 0	,	0	,	0	,	1	,	0	,	0	,	-1	,
                 0	,	0	,	0	,	-1	,	0	,	0	,	1	,
                 0	,	0	,	0	,	-1	,	0	,	0	,	-1	,
                 0	,	0	,	0	,	1	,	0	,	1	,	0	,
                 0	,	0	,	0	,	1	,	0	,	-1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                 1	,	0	,	0	,	0	,	0	,	0	,	1	,
                 1	,	0	,	0	,	0	,	0	,	0	,	-1	,
                 -1	,	0	,	0	,	0	,	0	,	0	,	1	,
                 -1	,	0	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	0	,	0	,	0	,	0	,	1	,	1	,
                 0	,	0	,	0	,	0	,	0	,	1	,	-1	,
                 0	,	0	,	0	,	0	,	0	,	-1	,	1	,
                 0	,	0	,	0	,	0	,	0	,	-1	,	-1	,
                 0	,	0	,	0	,	0	,	1	,	0	,	1	,
                 0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                 0	,	0	,	0	,	0	,	1	,	1	,	0	,
                 0	,	0	,	0	,	0	,	1	,	-1	,	0	,
                 0	,	0	,	0	,	0	,	-1	,	1	,	0	,
                 0	,	0	,	0	,	0	,	-1	,	-1	,	0	,
                 0	,	0	,	0	,	1	,	1	,	0	,	0	,
                 0	,	0	,	0	,	1	,	-1	,	0	,	0	,
                 0	,	0	,	0	,	-1	,	1	,	0	,	0	,
                 0	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                 0	,	0	,	1	,	0	,	1	,	0	,	0	,
                 0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                 0	,	0	,	1	,	1	,	0	,	0	,	0	,
                 0	,	0	,	1	,	-1	,	0	,	0	,	0	,
                 0	,	0	,	-1	,	1	,	0	,	0	,	0	,
                 0	,	0	,	-1	,	-1	,	0	,	0	,	0	,
                 0	,	1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	1	,	0	,	0	,	0	,	1	,	0	,
                 0	,	1	,	0	,	0	,	0	,	-1	,	0	,
                 0	,	-1	,	0	,	0	,	0	,	1	,	0	,
                 0	,	-1	,	0	,	0	,	0	,	-1	,	0	,
                 1	,	1	,	0	,	0	,	0	,	0	,	0	,
                 1	,	-1	,	0	,	0	,	0	,	0	,	0	,
                 -1	,	1	,	0	,	0	,	0	,	0	,	0	,
                 -1	,	-1	,	0	,	0	,	0	,	0	,	0	,
                 0	,	1	,	0	,	0	,	1	,	0	,	0	,
                 0	,	1	,	0	,	0	,	-1	,	0	,	0	,
                 0	,	-1	,	0	,	0	,	1	,	0	,	0	,
                 0	,	-1	,	0	,	0	,	-1	,	0	,	0	,
                 0	,	1	,	0	,	1	,	0	,	0	,	0	,
                 0	,	1	,	0	,	-1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                 0	,	1	,	1	,	0	,	0	,	0	,	0	,
                 0	,	1	,	-1	,	0	,	0	,	0	,	0	,
                 0	,	-1	,	1	,	0	,	0	,	0	,	0	,
                 0	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=87,byrow=T)
    # lm=list("Block 1"=B1, "Block 2"=B2)
    # return(lm)
  }
  if(v==8){
    B1<-matrix(c(-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,
                 -1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                 1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                 1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                 1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                 -1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                 -1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                 -1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                 -1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                 1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                 1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                 -1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                 1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                 -1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                 1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                 -1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                 1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                 4	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 -4	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	4	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	-4	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	4	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	-4	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	4	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	-4	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	4	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	-4	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	4	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	-4	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	4	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	-4	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	4	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	-4	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=147,byrow=T)
    B2<-matrix(c(1	,	1	,	0	,	1	,	0	,	0	,	1	,	0	,
                 1	,	1	,	0	,	1	,	0	,	0	,	-1	,	0	,
                 1	,	1	,	0	,	-1	,	0	,	0	,	1	,	0	,
                 1	,	1	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                 1	,	-1	,	0	,	1	,	0	,	0	,	1	,	0	,
                 1	,	-1	,	0	,	1	,	0	,	0	,	-1	,	0	,
                 1	,	-1	,	0	,	-1	,	0	,	0	,	1	,	0	,
                 1	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                 -1	,	1	,	0	,	1	,	0	,	0	,	1	,	0	,
                 -1	,	1	,	0	,	1	,	0	,	0	,	-1	,	0	,
                 -1	,	1	,	0	,	-1	,	0	,	0	,	1	,	0	,
                 -1	,	1	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                 -1	,	-1	,	0	,	1	,	0	,	0	,	1	,	0	,
                 -1	,	-1	,	0	,	1	,	0	,	0	,	-1	,	0	,
                 -1	,	-1	,	0	,	-1	,	0	,	0	,	1	,	0	,
                 -1	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	0	,
                 1	,	1	,	1	,	0	,	1	,	0	,	0	,	0	,
                 -1	,	1	,	1	,	0	,	1	,	0	,	0	,	0	,
                 1	,	1	,	1	,	0	,	-1	,	0	,	0	,	0	,
                 -1	,	1	,	1	,	0	,	-1	,	0	,	0	,	0	,
                 1	,	1	,	-1	,	0	,	1	,	0	,	0	,	0	,
                 -1	,	1	,	-1	,	0	,	1	,	0	,	0	,	0	,
                 1	,	1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                 -1	,	1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                 1	,	-1	,	1	,	0	,	1	,	0	,	0	,	0	,
                 -1	,	-1	,	1	,	0	,	1	,	0	,	0	,	0	,
                 1	,	-1	,	1	,	0	,	-1	,	0	,	0	,	0	,
                 -1	,	-1	,	1	,	0	,	-1	,	0	,	0	,	0	,
                 1	,	-1	,	-1	,	0	,	1	,	0	,	0	,	0	,
                 -1	,	-1	,	-1	,	0	,	1	,	0	,	0	,	0	,
                 1	,	-1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                 -1	,	-1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
                 0	,	1	,	1	,	1	,	0	,	1	,	0	,	0	,
                 0	,	-1	,	1	,	1	,	0	,	1	,	0	,	0	,
                 0	,	1	,	1	,	1	,	0	,	-1	,	0	,	0	,
                 0	,	-1	,	1	,	1	,	0	,	-1	,	0	,	0	,
                 0	,	1	,	1	,	-1	,	0	,	1	,	0	,	0	,
                 0	,	-1	,	1	,	-1	,	0	,	1	,	0	,	0	,
                 0	,	1	,	1	,	-1	,	0	,	-1	,	0	,	0	,
                 0	,	-1	,	1	,	-1	,	0	,	-1	,	0	,	0	,
                 0	,	1	,	-1	,	1	,	0	,	1	,	0	,	0	,
                 0	,	-1	,	-1	,	1	,	0	,	1	,	0	,	0	,
                 0	,	1	,	-1	,	1	,	0	,	-1	,	0	,	0	,
                 0	,	-1	,	-1	,	1	,	0	,	-1	,	0	,	0	,
                 0	,	1	,	-1	,	-1	,	0	,	1	,	0	,	0	,
                 0	,	-1	,	-1	,	-1	,	0	,	1	,	0	,	0	,
                 0	,	1	,	-1	,	-1	,	0	,	-1	,	0	,	0	,
                 0	,	-1	,	-1	,	-1	,	0	,	-1	,	0	,	0	,
                 0	,	0	,	1	,	1	,	1	,	0	,	1	,	0	,
                 0	,	0	,	-1	,	1	,	1	,	0	,	1	,	0	,
                 0	,	0	,	1	,	1	,	1	,	0	,	-1	,	0	,
                 0	,	0	,	-1	,	1	,	1	,	0	,	-1	,	0	,
                 0	,	0	,	1	,	1	,	-1	,	0	,	1	,	0	,
                 0	,	0	,	-1	,	1	,	-1	,	0	,	1	,	0	,
                 0	,	0	,	1	,	1	,	-1	,	0	,	-1	,	0	,
                 0	,	0	,	-1	,	1	,	-1	,	0	,	-1	,	0	,
                 0	,	0	,	1	,	-1	,	1	,	0	,	1	,	0	,
                 0	,	0	,	-1	,	-1	,	1	,	0	,	1	,	0	,
                 0	,	0	,	1	,	-1	,	1	,	0	,	-1	,	0	,
                 0	,	0	,	-1	,	-1	,	1	,	0	,	-1	,	0	,
                 0	,	0	,	1	,	-1	,	-1	,	0	,	1	,	0	,
                 0	,	0	,	-1	,	-1	,	-1	,	0	,	1	,	0	,
                 0	,	0	,	1	,	-1	,	-1	,	0	,	-1	,	0	,
                 0	,	0	,	-1	,	-1	,	-1	,	0	,	-1	,	0	,
                 1	,	0	,	0	,	1	,	1	,	1	,	0	,	0	,
                 1	,	0	,	0	,	-1	,	1	,	1	,	0	,	0	,
                 -1	,	0	,	0	,	1	,	1	,	1	,	0	,	0	,
                 -1	,	0	,	0	,	-1	,	1	,	1	,	0	,	0	,
                 1	,	0	,	0	,	1	,	1	,	-1	,	0	,	0	,
                 1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	0	,
                 -1	,	0	,	0	,	1	,	1	,	-1	,	0	,	0	,
                 -1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	0	,
                 1	,	0	,	0	,	1	,	-1	,	1	,	0	,	0	,
                 1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	0	,
                 -1	,	0	,	0	,	1	,	-1	,	1	,	0	,	0	,
                 -1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	0	,
                 1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	0	,
                 1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
                 -1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	0	,
                 -1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
                 0	,	1	,	0	,	0	,	1	,	1	,	1	,	0	,
                 0	,	1	,	0	,	0	,	-1	,	1	,	1	,	0	,
                 0	,	-1	,	0	,	0	,	1	,	1	,	1	,	0	,
                 0	,	-1	,	0	,	0	,	-1	,	1	,	1	,	0	,
                 0	,	1	,	0	,	0	,	1	,	1	,	-1	,	0	,
                 0	,	1	,	0	,	0	,	-1	,	1	,	-1	,	0	,
                 0	,	-1	,	0	,	0	,	1	,	1	,	-1	,	0	,
                 0	,	-1	,	0	,	0	,	-1	,	1	,	-1	,	0	,
                 0	,	1	,	0	,	0	,	1	,	-1	,	1	,	0	,
                 0	,	1	,	0	,	0	,	-1	,	-1	,	1	,	0	,
                 0	,	-1	,	0	,	0	,	1	,	-1	,	1	,	0	,
                 0	,	-1	,	0	,	0	,	-1	,	-1	,	1	,	0	,
                 0	,	1	,	0	,	0	,	1	,	-1	,	-1	,	0	,
                 0	,	1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,
                 0	,	-1	,	0	,	0	,	1	,	-1	,	-1	,	0	,
                 0	,	-1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,
                 1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,
                 1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,
                 1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,
                 1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,
                 -1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,
                 -1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,
                 1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,
                 1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,
                 1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,
                 1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,
                 -1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,
                 -1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,
                 1	,	1	,	0	,	0	,	0	,	1	,	0	,	1	,
                 1	,	1	,	0	,	0	,	0	,	1	,	0	,	-1	,
                 1	,	1	,	0	,	0	,	0	,	-1	,	0	,	1	,
                 1	,	1	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                 1	,	-1	,	0	,	0	,	0	,	1	,	0	,	1	,
                 1	,	-1	,	0	,	0	,	0	,	1	,	0	,	-1	,
                 1	,	-1	,	0	,	0	,	0	,	-1	,	0	,	1	,
                 1	,	-1	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                 -1	,	1	,	0	,	0	,	0	,	1	,	0	,	1	,
                 -1	,	1	,	0	,	0	,	0	,	1	,	0	,	-1	,
                 -1	,	1	,	0	,	0	,	0	,	-1	,	0	,	1	,
                 -1	,	1	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                 -1	,	-1	,	0	,	0	,	0	,	1	,	0	,	1	,
                 -1	,	-1	,	0	,	0	,	0	,	1	,	0	,	-1	,
                 -1	,	-1	,	0	,	0	,	0	,	-1	,	0	,	1	,
                 -1	,	-1	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                 0	,	1	,	1	,	0	,	0	,	0	,	1	,	1	,
                 0	,	1	,	1	,	0	,	0	,	0	,	1	,	-1	,
                 0	,	1	,	1	,	0	,	0	,	0	,	-1	,	1	,
                 0	,	1	,	1	,	0	,	0	,	0	,	-1	,	-1	,
                 0	,	1	,	-1	,	0	,	0	,	0	,	1	,	1	,
                 0	,	1	,	-1	,	0	,	0	,	0	,	1	,	-1	,
                 0	,	1	,	-1	,	0	,	0	,	0	,	-1	,	1	,
                 0	,	1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,
                 0	,	-1	,	1	,	0	,	0	,	0	,	1	,	1	,
                 0	,	-1	,	1	,	0	,	0	,	0	,	1	,	-1	,
                 0	,	-1	,	1	,	0	,	0	,	0	,	-1	,	1	,
                 0	,	-1	,	1	,	0	,	0	,	0	,	-1	,	-1	,
                 0	,	-1	,	-1	,	0	,	0	,	0	,	1	,	1	,
                 0	,	-1	,	-1	,	0	,	0	,	0	,	1	,	-1	,
                 0	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	1	,
                 0	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,
                 1	,	0	,	1	,	1	,	0	,	0	,	0	,	1	,
                 1	,	0	,	1	,	1	,	0	,	0	,	0	,	-1	,
                 -1	,	0	,	1	,	1	,	0	,	0	,	0	,	1	,
                 -1	,	0	,	1	,	1	,	0	,	0	,	0	,	-1	,
                 1	,	0	,	1	,	-1	,	0	,	0	,	0	,	1	,
                 1	,	0	,	1	,	-1	,	0	,	0	,	0	,	-1	,
                 -1	,	0	,	1	,	-1	,	0	,	0	,	0	,	1	,
                 -1	,	0	,	1	,	-1	,	0	,	0	,	0	,	-1	,
                 1	,	0	,	-1	,	1	,	0	,	0	,	0	,	1	,
                 1	,	0	,	-1	,	1	,	0	,	0	,	0	,	-1	,
                 -1	,	0	,	-1	,	1	,	0	,	0	,	0	,	1	,
                 -1	,	0	,	-1	,	1	,	0	,	0	,	0	,	-1	,
                 1	,	0	,	-1	,	-1	,	0	,	0	,	0	,	1	,
                 1	,	0	,	-1	,	-1	,	0	,	0	,	0	,	-1	,
                 -1	,	0	,	-1	,	-1	,	0	,	0	,	0	,	1	,
                 -1	,	0	,	-1	,	-1	,	0	,	0	,	0	,	-1	,
                 0	,	1	,	0	,	1	,	1	,	0	,	0	,	1	,
                 0	,	1	,	0	,	1	,	1	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	1	,	1	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	1	,	1	,	0	,	0	,	-1	,
                 0	,	1	,	0	,	1	,	-1	,	0	,	0	,	1	,
                 0	,	1	,	0	,	1	,	-1	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	1	,	-1	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	1	,	-1	,	0	,	0	,	-1	,
                 0	,	1	,	0	,	-1	,	1	,	0	,	0	,	1	,
                 0	,	1	,	0	,	-1	,	1	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	-1	,	1	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	-1	,	1	,	0	,	0	,	-1	,
                 0	,	1	,	0	,	-1	,	-1	,	0	,	0	,	1	,
                 0	,	1	,	0	,	-1	,	-1	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	-1	,	-1	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	-1	,	-1	,	0	,	0	,	-1	,
                 0	,	0	,	1	,	0	,	1	,	1	,	0	,	1	,
                 0	,	0	,	1	,	0	,	1	,	1	,	0	,	-1	,
                 0	,	0	,	-1	,	0	,	1	,	1	,	0	,	1	,
                 0	,	0	,	-1	,	0	,	1	,	1	,	0	,	-1	,
                 0	,	0	,	1	,	0	,	1	,	-1	,	0	,	1	,
                 0	,	0	,	1	,	0	,	1	,	-1	,	0	,	-1	,
                 0	,	0	,	-1	,	0	,	1	,	-1	,	0	,	1	,
                 0	,	0	,	-1	,	0	,	1	,	-1	,	0	,	-1	,
                 0	,	0	,	1	,	0	,	-1	,	1	,	0	,	1	,
                 0	,	0	,	1	,	0	,	-1	,	1	,	0	,	-1	,
                 0	,	0	,	-1	,	0	,	-1	,	1	,	0	,	1	,
                 0	,	0	,	-1	,	0	,	-1	,	1	,	0	,	-1	,
                 0	,	0	,	1	,	0	,	-1	,	-1	,	0	,	1	,
                 0	,	0	,	1	,	0	,	-1	,	-1	,	0	,	-1	,
                 0	,	0	,	-1	,	0	,	-1	,	-1	,	0	,	1	,
                 0	,	0	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,
                 0	,	0	,	0	,	1	,	0	,	1	,	1	,	1	,
                 0	,	0	,	0	,	1	,	0	,	1	,	1	,	-1	,
                 0	,	0	,	0	,	-1	,	0	,	1	,	1	,	1	,
                 0	,	0	,	0	,	-1	,	0	,	1	,	1	,	-1	,
                 0	,	0	,	0	,	1	,	0	,	1	,	-1	,	1	,
                 0	,	0	,	0	,	1	,	0	,	1	,	-1	,	-1	,
                 0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	1	,
                 0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	-1	,
                 0	,	0	,	0	,	1	,	0	,	-1	,	1	,	1	,
                 0	,	0	,	0	,	1	,	0	,	-1	,	1	,	-1	,
                 0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	1	,
                 0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	-1	,
                 0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	1	,
                 0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	-1	,
                 0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	1	,
                 0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,
                 1	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,
                 1	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,
                 1	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,
                 1	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,
                 -1	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,
                 -1	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,
                 -1	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,
                 -1	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,
                 1	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,
                 1	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,
                 1	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,
                 1	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
                 -1	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,
                 -1	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,
                 -1	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,
                 -1	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=228,byrow=T)
    # lm=list("Block 1"=B1, "Block 2"=B2)
    # return(lm)
  }
  if(v==9){
    B1<-matrix(c(-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                 1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                 -1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                 1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                 1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                 -1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                 1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                 1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                 1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                 -1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                 -1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                 1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                 -1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                 1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
                 -1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                 1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                 -1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                 1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                 -1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                 1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
                 -1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
                 1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
                 -1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                 1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	1	,	-1	,	1	,	1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                 1	,	1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
                 -1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
                 -1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                 1	,	-1	,	1	,	-1	,	1	,	1	,	1	,	-1	,	1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,
                 -1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
                 -1	,	-1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 -1	,	1	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
                 1	,	1	,	1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                 -1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                 1	,	-1	,	-1	,	1	,	1	,	-1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	1	,	1	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
                 -1	,	1	,	-1	,	1	,	1	,	1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 1	,	-1	,	1	,	-1	,	-1	,	1	,	1	,	1	,	1	,
                 1	,	1	,	1	,	-1	,	1	,	1	,	1	,	1	,	1	,
                 1	,	-1	,	1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                 1	,	1	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
                 1	,	1	,	-1	,	1	,	1	,	-1	,	1	,	-1	,	1	,
                 1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
                 -1	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
                 4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 -4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	-4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	-4.75682846	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	4.75682846	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	-4.75682846	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	4.75682846	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	-4.75682846	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	4.75682846	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	-4.75682846	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	4.75682846	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	-4.75682846	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	4.75682846	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	-4.75682846	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	4.75682846	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	-4.75682846	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=277,byrow=T)
    B2<-matrix(c(1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,	0	,
                 1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,	0	,
                 1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,	0	,
                 1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                 1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,	0	,
                 1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,	0	,
                 1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,	0	,
                 1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                 -1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,	0	,
                 -1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,	0	,
                 -1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,	0	,
                 -1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,	0	,
                 -1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,	0	,
                 0	,	1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,
                 0	,	1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,
                 0	,	1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,
                 0	,	1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,
                 0	,	1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,
                 0	,	1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,
                 0	,	1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,
                 0	,	1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,
                 0	,	-1	,	0	,	1	,	0	,	0	,	1	,	1	,	0	,
                 0	,	-1	,	0	,	1	,	0	,	0	,	1	,	-1	,	0	,
                 0	,	-1	,	0	,	1	,	0	,	0	,	-1	,	1	,	0	,
                 0	,	-1	,	0	,	1	,	0	,	0	,	-1	,	-1	,	0	,
                 0	,	-1	,	0	,	-1	,	0	,	0	,	1	,	1	,	0	,
                 0	,	-1	,	0	,	-1	,	0	,	0	,	1	,	-1	,	0	,
                 0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	1	,	0	,
                 0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,
                 0	,	0	,	1	,	0	,	1	,	0	,	0	,	1	,	1	,
                 0	,	0	,	1	,	0	,	1	,	0	,	0	,	1	,	-1	,
                 0	,	0	,	1	,	0	,	1	,	0	,	0	,	-1	,	1	,
                 0	,	0	,	1	,	0	,	1	,	0	,	0	,	-1	,	-1	,
                 0	,	0	,	1	,	0	,	-1	,	0	,	0	,	1	,	1	,
                 0	,	0	,	1	,	0	,	-1	,	0	,	0	,	1	,	-1	,
                 0	,	0	,	1	,	0	,	-1	,	0	,	0	,	-1	,	1	,
                 0	,	0	,	1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,
                 0	,	0	,	-1	,	0	,	1	,	0	,	0	,	1	,	1	,
                 0	,	0	,	-1	,	0	,	1	,	0	,	0	,	1	,	-1	,
                 0	,	0	,	-1	,	0	,	1	,	0	,	0	,	-1	,	1	,
                 0	,	0	,	-1	,	0	,	1	,	0	,	0	,	-1	,	-1	,
                 0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	1	,	1	,
                 0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	1	,	-1	,
                 0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	1	,
                 0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,	-1	,
                 1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,	1	,
                 -1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,	1	,
                 1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,	-1	,
                 -1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,	-1	,
                 1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,	1	,
                 -1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,	1	,
                 1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,	-1	,
                 -1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,	-1	,
                 1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,	1	,
                 -1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,	1	,
                 1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,	-1	,
                 -1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,	-1	,
                 1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	1	,
                 -1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	1	,
                 1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,
                 -1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,	-1	,
                 1	,	1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,
                 1	,	-1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,
                 -1	,	1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,
                 -1	,	-1	,	0	,	0	,	1	,	0	,	1	,	0	,	0	,
                 1	,	1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                 1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                 -1	,	1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                 -1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	0	,	0	,
                 1	,	1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                 1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                 -1	,	1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                 -1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	0	,	0	,
                 1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                 1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                 -1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                 -1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	0	,	0	,
                 0	,	1	,	1	,	0	,	0	,	1	,	0	,	1	,	0	,
                 0	,	1	,	-1	,	0	,	0	,	1	,	0	,	1	,	0	,
                 0	,	-1	,	1	,	0	,	0	,	1	,	0	,	1	,	0	,
                 0	,	-1	,	-1	,	0	,	0	,	1	,	0	,	1	,	0	,
                 0	,	1	,	1	,	0	,	0	,	1	,	0	,	-1	,	0	,
                 0	,	1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	0	,
                 0	,	-1	,	1	,	0	,	0	,	1	,	0	,	-1	,	0	,
                 0	,	-1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	0	,
                 0	,	1	,	1	,	0	,	0	,	-1	,	0	,	1	,	0	,
                 0	,	1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	0	,
                 0	,	-1	,	1	,	0	,	0	,	-1	,	0	,	1	,	0	,
                 0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	0	,
                 0	,	1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                 0	,	1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                 0	,	-1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                 0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	0	,
                 0	,	0	,	1	,	1	,	0	,	0	,	1	,	0	,	1	,
                 0	,	0	,	1	,	-1	,	0	,	0	,	1	,	0	,	1	,
                 0	,	0	,	-1	,	1	,	0	,	0	,	1	,	0	,	1	,
                 0	,	0	,	-1	,	-1	,	0	,	0	,	1	,	0	,	1	,
                 0	,	0	,	1	,	1	,	0	,	0	,	1	,	0	,	-1	,
                 0	,	0	,	1	,	-1	,	0	,	0	,	1	,	0	,	-1	,
                 0	,	0	,	-1	,	1	,	0	,	0	,	1	,	0	,	-1	,
                 0	,	0	,	-1	,	-1	,	0	,	0	,	1	,	0	,	-1	,
                 0	,	0	,	1	,	1	,	0	,	0	,	-1	,	0	,	1	,
                 0	,	0	,	1	,	-1	,	0	,	0	,	-1	,	0	,	1	,
                 0	,	0	,	-1	,	1	,	0	,	0	,	-1	,	0	,	1	,
                 0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,	1	,
                 0	,	0	,	1	,	1	,	0	,	0	,	-1	,	0	,	-1	,
                 0	,	0	,	1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,
                 0	,	0	,	-1	,	1	,	0	,	0	,	-1	,	0	,	-1	,
                 0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,
                 1	,	0	,	0	,	1	,	1	,	0	,	0	,	1	,	0	,
                 1	,	0	,	0	,	1	,	-1	,	0	,	0	,	1	,	0	,
                 1	,	0	,	0	,	-1	,	1	,	0	,	0	,	1	,	0	,
                 1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	1	,	0	,
                 -1	,	0	,	0	,	1	,	1	,	0	,	0	,	1	,	0	,
                 -1	,	0	,	0	,	1	,	-1	,	0	,	0	,	1	,	0	,
                 -1	,	0	,	0	,	-1	,	1	,	0	,	0	,	1	,	0	,
                 -1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	1	,	0	,
                 1	,	0	,	0	,	1	,	1	,	0	,	0	,	-1	,	0	,
                 1	,	0	,	0	,	1	,	-1	,	0	,	0	,	-1	,	0	,
                 1	,	0	,	0	,	-1	,	1	,	0	,	0	,	-1	,	0	,
                 1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
                 -1	,	0	,	0	,	1	,	1	,	0	,	0	,	-1	,	0	,
                 -1	,	0	,	0	,	1	,	-1	,	0	,	0	,	-1	,	0	,
                 -1	,	0	,	0	,	-1	,	1	,	0	,	0	,	-1	,	0	,
                 -1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
                 0	,	1	,	0	,	0	,	1	,	1	,	0	,	0	,	1	,
                 0	,	1	,	0	,	0	,	1	,	-1	,	0	,	0	,	1	,
                 0	,	1	,	0	,	0	,	-1	,	1	,	0	,	0	,	1	,
                 0	,	1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	0	,	1	,	1	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	0	,	1	,	-1	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	0	,	-1	,	1	,	0	,	0	,	1	,
                 0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	1	,
                 0	,	1	,	0	,	0	,	1	,	1	,	0	,	0	,	-1	,
                 0	,	1	,	0	,	0	,	1	,	-1	,	0	,	0	,	-1	,
                 0	,	1	,	0	,	0	,	-1	,	1	,	0	,	0	,	-1	,
                 0	,	1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	0	,	1	,	1	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	0	,	1	,	-1	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	0	,	-1	,	1	,	0	,	0	,	-1	,
                 0	,	-1	,	0	,	0	,	-1	,	-1	,	0	,	0	,	-1	,
                 1	,	0	,	1	,	1	,	1	,	0	,	0	,	0	,	0	,
                 1	,	0	,	1	,	1	,	-1	,	0	,	0	,	0	,	0	,
                 1	,	0	,	1	,	-1	,	1	,	0	,	0	,	0	,	0	,
                 1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                 1	,	0	,	-1	,	1	,	1	,	0	,	0	,	0	,	0	,
                 1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	0	,	0	,
                 1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	0	,	0	,
                 1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	1	,	1	,	1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	1	,	1	,	-1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	1	,	-1	,	1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	-1	,	1	,	1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	0	,	0	,
                 -1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,	0	,
                 0	,	1	,	0	,	1	,	1	,	1	,	0	,	0	,	0	,
                 0	,	1	,	0	,	1	,	1	,	-1	,	0	,	0	,	0	,
                 0	,	1	,	0	,	1	,	-1	,	1	,	0	,	0	,	0	,
                 0	,	1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	0	,
                 0	,	1	,	0	,	-1	,	1	,	1	,	0	,	0	,	0	,
                 0	,	1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	0	,
                 0	,	1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	0	,
                 0	,	1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	1	,	1	,	1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	1	,	1	,	-1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	1	,	-1	,	1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	-1	,	1	,	1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	0	,
                 0	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
                 0	,	0	,	1	,	0	,	1	,	1	,	1	,	0	,	0	,
                 0	,	0	,	1	,	0	,	1	,	1	,	-1	,	0	,	0	,
                 0	,	0	,	1	,	0	,	1	,	-1	,	1	,	0	,	0	,
                 0	,	0	,	1	,	0	,	1	,	-1	,	-1	,	0	,	0	,
                 0	,	0	,	1	,	0	,	-1	,	1	,	1	,	0	,	0	,
                 0	,	0	,	1	,	0	,	-1	,	1	,	-1	,	0	,	0	,
                 0	,	0	,	1	,	0	,	-1	,	-1	,	1	,	0	,	0	,
                 0	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	1	,	1	,	1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	1	,	1	,	-1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	1	,	-1	,	1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	-1	,	1	,	1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	0	,	0	,
                 0	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
                 0	,	0	,	0	,	1	,	0	,	1	,	1	,	1	,	0	,
                 0	,	0	,	0	,	1	,	0	,	1	,	1	,	-1	,	0	,
                 0	,	0	,	0	,	1	,	0	,	1	,	-1	,	1	,	0	,
                 0	,	0	,	0	,	1	,	0	,	1	,	-1	,	-1	,	0	,
                 0	,	0	,	0	,	1	,	0	,	-1	,	1	,	1	,	0	,
                 0	,	0	,	0	,	1	,	0	,	-1	,	1	,	-1	,	0	,
                 0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	1	,	0	,
                 0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	1	,	1	,	1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	1	,	1	,	-1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	0	,
                 0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,
                 0	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,	1	,
                 0	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,	-1	,
                 0	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,	1	,
                 0	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,	-1	,
                 0	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,	1	,
                 0	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,	-1	,
                 0	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	1	,
                 0	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,	-1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,	1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,	-1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,	-1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,	-1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	1	,
                 0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,
                 1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,
                 -1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	1	,
                 1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,
                 -1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	-1	,
                 1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,
                 -1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	1	,
                 1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,
                 -1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	-1	,
                 1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,
                 -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	1	,
                 1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,
                 -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	-1	,
                 1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,
                 -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	1	,
                 1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
                 -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
                 1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,
                 1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,
                 -1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,
                 -1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,
                 1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                 1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                 -1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                 -1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,
                 1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                 1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                 -1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                 -1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,
                 1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                 1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                 -1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                 -1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,
                 1	,	1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 1	,	1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 1	,	-1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 -1	,	1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 -1	,	1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 -1	,	-1	,	1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 -1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	1	,	0	,
                 1	,	1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 1	,	1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 1	,	-1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 -1	,	1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 -1	,	1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 -1	,	-1	,	1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 -1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	-1	,	0	,
                 0	,	1	,	1	,	1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	1	,	1	,	-1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	1	,	-1	,	1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	-1	,	1	,	1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	-1	,	1	,	-1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	-1	,	-1	,	1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	1	,
                 0	,	1	,	1	,	1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	1	,	1	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	1	,	-1	,	1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	-1	,	1	,	1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	-1	,	1	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	-1	,	-1	,	1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	-1	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
                 0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	),nrow=291,byrow=T)

    # print(B2)

  }
  #########################

  Pred3.var<-function(matrix){
    matfA<-matrix
    mat1<-matrix(,nrow=nrow(matfA),ncol=0)
    p=1
    while(p<=v){
      x1<-matrix(,nrow=nrow(matfA),ncol=0)
      x1<-(matfA[,p])^2
      mat1<-cbind(mat1,x1)
      p=p+1
    }
    ############normal matrix
    #matfA
    ##########sq terms mat1
    #mat1
    ##############interactions
    b1=1
    b2=1
    mat12<-matrix(,nrow=nrow(matfA),ncol=0)
    while(b1<v){
      b2=b1+1
      while(b2<=v){
        mat2<-matrix(,nrow=0,ncol=1)
        mat2<-matfA[,b1]*matfA[,b2]
        mat12<-cbind(mat12,mat2)
        b2=b2+1
      }

      b1=b1+1

    }
    #########interactions
    #mat12
    ############tricky portion
    new<-matfA

    o=1
    while(o<=v){
      matt<-matrix(,nrow=nrow(mat1),ncol=0)
      matt<-mat1[,c(o)]
      mat11<-mat1[,-c(o)]
      mat11<-cbind(matt,mat11)
      changed<-cbind(new[,o],mat11)
      mat123<-matrix(,nrow=nrow(new),ncol=0)
      q=1
      while(q<ncol(changed)){

        x1<-matrix(,nrow=nrow(new),ncol=0)
        x1<-changed[,1]*changed[,q+1]
        mat123<-cbind(mat123,x1)
        q=q+1
      }
      mat12<-cbind(mat12,new[,o],mat123)
      o=o+1
    }
    #ncol(mat12)
    #################################checking


    #############3 factor interactions
    l1=1
    l2=1
    l3=1
    int<-matrix(,nrow=nrow(mat1),ncol=0)
    while(l1<=v-2){
      l2=l1+1

      while(l2<=v-1){
        l3=l2+1
        while(l3<=v){
          mat2<-matrix(,nrow=0,ncol=1)
          mat2<-matfA[,l1]*matfA[,l2]*matfA[,l3]
          int<-cbind(int,mat2)
          l3=l3+1
        }
        l2=l2+1
      }

      l1=l1+1

    }
    #ncol(int)
    #########################
    x_mat<-cbind(mat1,mat12,int)
    x_mat<-cbind((matrix(1,nrow=nrow(x_mat),ncol=1)),x_mat)
    rownames(x_mat)<-NULL
    colnames(x_mat)<-NULL
    x_prime_x<-t(x_mat)%*%x_mat
    ###############
    x_matrix<-x_mat
    k1=1
    var<-c()
    while(k1<=nrow(x_matrix))
    {
      V=t(x_matrix[k1,])
      b<-t(V)
      v_y_hat<-V %*%solve(x_prime_x) %*% b
      var<-c(var,v_y_hat)
      k1<-k1+1
    }
    variance_of_esitmated_response<-round(var,digits = 3 )
    lm=list("col"=ncol(x_matrix),"mvar"=max(variance_of_esitmated_response))
    return(lm)
  }
  #}#################
  N=nrow(rbind(B1,B2))
  p=Pred3.var(rbind(B1,B2))$"col"
  mvar=Pred3.var(rbind(B1,B2))$"mvar"
  #####
  G_eff=p/(mvar*N)
  G_eff=round(G_eff,digits = 5)
  B1=round(B1,digits = 5)
  B2=round(B2,digits = 5)
  #z=round(z,digits = 5)
  B1=format(B1,nsmall=5)
  B1=noquote(B1)
  B2=format(B2,nsmall=5)
  B2=noquote(B2)

  ################################################
 message("Symmetric Sequential Third Design")
  cat("\n")
  message("Block 1")
  print(B1)
  cat("\n")
  message("Block 2")
  print(B2)
  cat("\n")
  message("G-efficiency")
  print(G_eff)
  # lm=list("Block 1"=B1, "Block 2"=B2,"G-efficiency"=G_eff)
  # return(lm)
}


