% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.geno.R
\name{get.geno}
\alias{get.geno}
\title{Derive genotypes of selected individuals}
\usage{
get.geno(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  chromosome = "all",
  export.alleles = FALSE,
  non.genotyped.as.missing = FALSE,
  use.id = TRUE,
  array = NULL,
  remove.missing = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{chromosome}{Limit the genotype output to a selected chromosome (default: "all")}

\item{export.alleles}{If TRUE export underlying alleles instead of just 012}

\item{non.genotyped.as.missing}{Set to TRUE to replace non-genotyped markers with NA}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: TRUE)}

\item{array}{Use only markers available on the array}

\item{remove.missing}{Remove markers not genotyped in any individual from the export}
}
\value{
Genotype data for in gen/database/cohorts selected individuals
}
\description{
Function to derive genotypes of selected individuals
}
\examples{
data(ex_pop)
geno <- get.geno(ex_pop, gen=2)
}
