% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.snapshot.R
\name{get.snapshot}
\alias{get.snapshot}
\title{Derive snapshot of selected individuals}
\usage{
get.snapshot(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  phenotype.data = FALSE,
  gain.data = FALSE,
  digits = 3,
  use.all.copy = TRUE,
  time.diff = NA
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{phenotype.data}{Set to TRUE to include information of number of phenotypes generated}

\item{gain.data}{Set to TRUE to add information on changes in genetic level between cohorts (default: FALSE)}

\item{digits}{Number of digits provided for the gain.data output (default: 3)}

\item{use.all.copy}{Set to TRUE to extract phenotyping}

\item{time.diff}{Set to a target time interval to receive information between transitions to other cohorts (default: NA)}
}
\value{
Snapshot-matrix
}
\description{
Function to derive snapshot of genotyping/phenotyping state of selected individuals
}
\examples{
data(ex_pop)
get.snapshot(ex_pop, gen = 2)
}
