% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_lw}
\alias{coo_lw}
\title{Calculates length and width of a shape}
\usage{
coo_lw(coo)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or Coo object}
}
\value{
a vector of two \code{numeric}: the length and the width.
}
\description{
Returns the length and width of a shape based on their iniertia axis
i.e. alignment to the x-axis. The length is defined as
the range along the x-axis; the width as the range on the y-axis.
}
\examples{
coo_lw(bot[1])
}
\seealso{
\link{coo_length}, \link{coo_width}.

Other coo_ descriptors: 
\code{\link{coo_angle_edges}()},
\code{\link{coo_angle_tangent}()},
\code{\link{coo_area}()},
\code{\link{coo_boundingbox}()},
\code{\link{coo_chull}()},
\code{\link{coo_circularity}()},
\code{\link{coo_convexity}()},
\code{\link{coo_eccentricity}},
\code{\link{coo_elongation}()},
\code{\link{coo_length}()},
\code{\link{coo_rectangularity}()},
\code{\link{coo_rectilinearity}()},
\code{\link{coo_scalars}()},
\code{\link{coo_solidity}()},
\code{\link{coo_tac}()},
\code{\link{coo_width}()}
}
\concept{coo_ descriptors}
