% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-PCA.R
\name{get_chull_area}
\alias{get_chull_area}
\alias{get_chull_volume}
\title{Calculates convex hull area/volume of PCA scores}
\usage{
get_chull_area(x, fac, xax = 1, yax = 2)

get_chull_volume(x, fac, xax = 1, yax = 2, zax = 3)
}
\arguments{
\item{x}{a PCA object}

\item{fac}{(optionnal) column name or ID from the $fac slot.}

\item{xax}{the first PC axis to use (1 by default)}

\item{yax}{the second PC axis (2 by default)}

\item{zax}{the third PC axis (3 by default only for volume)}
}
\value{
If fac is not provided global area/volume is returned; otherwise a named
list for every level of fac
}
\description{
May be useful to compare shape diversity. Expressed in PCA units that should
only be compared within the same PCA.
}
\details{
get_chull_area is calculated using \link{coo_chull} followed by \link{coo_area};
get_chull_volume is calculated using geometry::convexhulln
}
\examples{
bp <- PCA(efourier(bot, 12))
get_chull_area(bp)
get_chull_area(bp, 1)

get_chull_volume(bp)
get_chull_volume(bp, 1)
}
