% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFit.R
\name{getFit}
\alias{getFit}
\title{Get fit indices from Latent Growth Models (LGM)}
\usage{
getFit(lgm_object)
}
\arguments{
\item{lgm_object}{A single LGM \code{mplusObject} or a list of LGM \code{mplusObject} (nested lists supported).}
}
\value{
A  data frame with a row for each LGM of the input list.
}
\description{
Extract key information from Mplus LGM objects, including model summaries,
fit statistics, class details, warnings, and errors. The function accounts for non-converging
models and compiles the extracted information into a single data frame to facilitate
model evaluation and comparison.
}
\details{
\itemize{
\item - Model summaries such as the title, log-likelihood value and  number of observations, parameters and latent classes.
\item - Model fit indices such as the BIC, aBIC, AIC, AICC and CAIC along with statistics from the BLRT and adjusted LMR-LRT, if requested.
\item - Latent class counts and proportions.
\item - Classification confidence measures such as the average posterior probabilities (APPA) and entropy.
\item - Mplus warnings or errors encountered during model estimation.
}

This output facilitates side-by-side comparison of models to support model evaluation and selection.
}
\examples{
\donttest{
# Example usage:
fit_indices <- getFit(lgm_object = GCM_model)
fit_indices <- getFit(lgm_object = list(GCM_model, GBTM_models, LCGA_models))

print(fit_indices)
}
}
