% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNM_class_methods.R
\docType{class}
\name{MNM-class}
\alias{MNM-class}
\title{Multi-Species N-Mixture (MNM) Model Class}
\description{
The \code{"MNM"} class represents a multi-species N-mixture model object fitted using Nimble.
It contains key model outputs, including parameter estimates, input data, predictions,
log-likelihood, convergence diagnostics, and model summaries.
}
\section{Slots}{

\describe{
\item{\code{summary}}{A \code{data.frame} summarizing the model output, including posterior means, standard deviations, and convergence diagnostics (e.g., Rhat values).}

\item{\code{n_parameters}}{A numeric value indicating the number of parameters estimated in the model.}

\item{\code{estimates}}{Mean estimates for all monitored parameters.}

\item{\code{fitted_Y}}{An array containing the fitted values (predicted responses) for the model.}

\item{\code{data}}{An array containing the input data used to fit the model.}

\item{\code{logLik}}{A numeric value representing the log-likelihood of the model.}

\item{\code{n_converged}}{A numeric value indicating the number of parameters with Rhat < 1.1, showing convergence.}

\item{\code{plot}}{A list containing traceplots and density plots for all monitored variables.}
}}

