% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateData.R
\name{simulateData}
\alias{simulateData}
\title{Simulate Data for Multi-Species N-Mixture Models}
\usage{
simulateData(
  model = "MNM",
  R = 10,
  S = 2,
  T = 5,
  prob = "all",
  abundance = "small",
  K = 4,
  theta = 0.5
)
}
\arguments{
\item{model}{Character. Specifies the model type. Options are \code{"MNM"}, \code{"Hurdle"}, \code{"AR"}, \code{"HurdleAR"}. Default is \code{"MNM"}.}

\item{R}{Integer. Number of sites. Default is \code{10}.}

\item{S}{Integer. Number of species. Default is \code{2}.}

\item{T}{Integer. Number of replicates. Default is \code{5}.}

\item{prob}{Character. Specifies the range of detection probabilities:
\itemize{
\item \code{"small"}: Detection probabilities < 0.4.
\item \code{"large"}: Detection probabilities > 0.5.
\item \code{"all"}: Detection probabilities between 0.01 and 0.99 (default).
}}

\item{abundance}{Character. Specifies the abundance size:
\itemize{
\item \code{"small"}: Latent species abundance between 0 and 50.
\item \code{"large"}: Latent species abundance between 0 and 700.
Default is \code{"small"}.
}}

\item{K}{Integer. Number of time points (used for AR models). Default is \code{4}.}

\item{theta}{Numeric. Probability of zero-inflation (used for hurdle models). Default is \code{0.5}.}
}
\value{
A list containing:
\itemize{
\item \strong{Y}: Array of observed abundances.
\item \strong{N}: Array of true abundances.
\item \strong{p}: Array of detection probabilities.
\item \strong{Sigma}: Covariance matrix for the multivariate normal variable \code{a}.
\item \strong{mu}: Mean vector for the multivariate normal variable \code{a}.
\item \strong{lambda}: Latent abundance rate parameter.
\item \strong{correlation}: Correlation matrix derived from \code{Sigma}.
\item \strong{R, T, S, K}: Number of sites, sampling occasions, species, and time points.
\item Additional elements depending on the model type:
\itemize{
\item \strong{phi}: Autoregression parameter (AR and HurdleAR models).
\item \strong{muPhi}: Mean of the autoregressive parameter (AR and HurdleAR models).
\item \strong{varPhi}: Variance of the autoregressive parameter (AR and HurdleAR models).
\item \strong{zeros}: Matrix of zero-indicators for hurdle models.
\item \strong{theta}: Zero-inflation parameter for hurdle models.
}
}
}
\description{
Simulates multi-species correlated abundance data for various Multi-Species N-Mixture (MNM) model types, including standard MNM, Hurdle, AR (autoregressive), and HurdleAR models.
}
\details{
This function generates abundance data for multi-species N-mixture models under different configurations:
\itemize{
\item \strong{MNM}: Standard multi-species N-mixture model.
\item \strong{Hurdle}: Includes a hurdle component to model zero-inflated data.
\item \strong{AR}: Includes an autoregressive (AR) component for temporal dependencies.
\item \strong{HurdleAR}: Combines hurdle and AR components for zero-inflation and temporal dependencies.
The output includes observed and true abundances, detection probabilities, latent variables, and covariance information for the random effects.
}
}
\examples{
# Simulate data for a standard MNM model
data <- simulateData(model = "MNM", R = 10, S = 3, T = 5, prob = "all",
abundance = "small")

# Simulate data for a hurdle model
data <- simulateData(model = "Hurdle", R = 10, S = 3, T = 5, prob = "large",
abundance = "large", theta = 0.3)

# Simulate data for an autoregressive model
data <- simulateData(model = "AR", R = 10, S = 2, T = 5, K = 4, prob = "small",
abundance = "small")

# Simulate data for a hurdle autoregressive model
data <- simulateData(model = "HurdleAR", R = 10, S = 3, T = 5, K = 4, prob = "all",
abundance = "large", theta = 0.5)

}
\seealso{
\itemize{
\item \code{simulateData_MNM}: Helper function for simulating standard MNM data.
\item \code{simulateData_Hurdle}: Helper function for simulating hurdle MNM data.
\item \code{simulateData_AR}: Helper function for simulating AR MNM data.
\item \code{simulateData_Hurdle_AR}: Helper function for simulating hurdle AR MNM data.
}
}
