% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPT_discrete_plot.R
\name{NPT_discrete_plot}
\alias{NPT_discrete_plot}
\title{Visualize Discrete Niche Classification Tree}
\usage{
NPT_discrete_plot(data, point_size = 2.5)
}
\arguments{
\item{data}{A data frame containing niche classification results, typically the
\code{niche_classification} output from \code{\link{NPT_discrete}}. Must contain:
\itemize{
\item \code{species} - Character column with species names
\item \code{niche_code} - Character column with comma-separated niche codes
(e.g., "1,2,1")
\item Additional columns representing cluster assignments for each dimension
(used as layer names in the visualization)
}}

\item{point_size}{Numeric value specifying the size of nodes in the tree plot.
Default is \code{2.5}.}
}
\value{
A \code{ggplot} object representing the niche classification tree. The plot
can be further customized using standard \code{ggplot2} functions.
}
\description{
This function creates a hierarchical tree visualization of the discrete niche
classification results generated by \code{\link{NPT_discrete}}. The visualization
displays the niche classification structure as a directed tree graph, where each
level represents a niche dimension and nodes represent different clusters within
each dimension.
}
\details{
The function constructs a hierarchical tree visualization where:
\itemize{
\item \strong{Root node}: Represents the starting point of the classification
\item \strong{Level 1 nodes}: Show clusters in the first niche dimension
\item \strong{Level 2 nodes}: Show clusters in the second niche dimension,
connected to their parent clusters from level 1
\item \strong{Subsequent levels}: Continue the hierarchical pattern for
additional dimensions
}

\strong{Visualization Features:}
\itemize{
\item Different colors for each niche dimension level using NPG color palette
\item Directed edges showing the hierarchical relationships
\item Node labels indicating cluster numbers
\item Legend showing niche levels
\item Automatic detection of the number of dimensions from niche codes
}

\strong{Tree Construction Algorithm:}

The function automatically determines the number of niche dimensions by parsing
the first niche code, then recursively builds the tree structure:
\enumerate{
\item Parse niche codes to extract individual dimension values
\item Create nodes for each unique cluster combination
\item Establish parent-child relationships between levels
\item Generate the final graph structure for visualization
}
}
\note{
\itemize{
\item The function assumes that niche codes are comma-separated strings
\item Layer names are automatically extracted from column names (excluding
"species" and "niche_code")
\item If the number of layer names doesn't match dimensions, generic names
(Layer1, Layer2, etc.) are used
}
}
\examples{
\dontrun{
# Load and prepare data
data(PFF)
rownames(PFF) <- PFF$species
PFF_traits <- PFF[, c("SLA", "SRL", "Leaf_Nmass", "Root_Nmass","Height",
                      "Leaf_CN", "Root_CN","SeedMass", "FltDate", "FltDur")]
# Perform log transformation of data and remove missing values
PFF_traits <- log(na.omit(PFF_traits))
head(PFF_traits)
# Define trait dimensions
dimension <- list(Grow = c("SLA", "SRL", "Leaf_Nmass", "Root_Nmass"),
                  Survive = c("Height", "Leaf_CN", "Root_CN"),
                  Reproductive = c("SeedMass", "FltDate", "FltDur"))

set.seed(123)
discrete_result <- NPT_discrete(data = PFF_traits, dimension = dimension)
NPT_discrete_plot(discrete_result$niche_classification)

}

}
\references{
\enumerate{
\item Winemiller, K. O., Fitzgerald, D. B., Bower, L. M., & Pianka, E. R. (2015).
Functional traits, convergent evolution, and periodic tables of niches.
Ecology letters, 18(8), 737-751.
\item Pianka, E. R., Vitt, L. J., Pelegrin, N., Fitzgerald, D. B., & Winemiller, K. O. (2017).
Toward a periodic table of niches, or exploring the lizard niche hypervolume.
The American Naturalist, 190(5), 601-616.
}
}
