% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCSCopCdf.R
\name{NCSCopCdf}
\alias{NCSCopCdf}
\title{Distribution function of a non-central squared copula}
\usage{
NCSCopCdf(u, family, param, dof = NULL)
}
\arguments{
\item{u}{(nx2) data matrix of pseudo-observations.}

\item{family}{'Gaussian' , 't' , 'Clayton' , 'Frank' , 'Gumbel'.}

\item{param}{c(a1,a2,tau)  where  a1,a2  are the non-negative non-centrality}

\item{dof}{degrees of freedom of the Student copula (if needed).}
}
\value{
\item{cdf}{Non-central squared copula evaluated at points u.}
}
\description{
This function computes the distribution function a non-central squared copula
}
\examples{
param = c(0.8,2.5,0.7);
u = matrix(c(0.2,0.6,0.3,0.5,0.7,0.9),ncol=2,byrow=TRUE);
cdf=NCSCopCdf(u,'Clayton',param);

}
\author{
Bouchra R. Nasri, August 14, 2019
}
