% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sng.R
\name{m_ng}
\alias{m_ng}
\title{Modified NG prior via FS scores}
\description{
Modified Normal Gammp prior calculates the posterior distribution for the fine mapping study.
The number of individuals must be greater than the number of SNPs.
}

\usage{
m_ng (y, data, FS, medstar = c(0.01, 0.0001),  numb = 100, burnin = 1, every = 1)
}
\arguments{
\item{y}{
A vector of the pheontype.
}
\item{data}{
An \eqn{N \times p} finemap data, where \eqn{N} and \eqn{p} denote the samples
and number of SNPs respectively.
}
\item{FS}{
FS scores for each SNP and it takes value from 0 and 1 or NA for missing FS.
}
\item{medstar}{
The value of M where M takes two values.
}
\item{numb}{
Number of samples for each SNP.
}
\item{burnin}{
The amount of burn-in for the MCMC sample.
}
\item{every}{
The amount of thining for the MCMC sample.
}
}
\value{
A list including:
\item{alpha}{
A vector of the posterior distribution of the intercept.
}
\item{beta}{
A matrix of the posterior distribution of the effect sizes.
}
\item{sigmasq}{
A vector of the posterior distribution of \eqn{\sigma^2}.
}
\item{psi}{
A matrix of the posterior distribution of \eqn{\psi}.
}
\item{lambda}{
A vector of the posterior distribution of \eqn{\lambda}.
}
\item{gammasq}{
A vector of the posterior distribution of \eqn{\gamma^2}.
}
\item{W}{
A vector of the posterior distribution of \eqn{W}.
}
\item{H}{
A vector of the posterior distribution of \eqn{H}.
}
}


\author{
Abulaziz Alenazi.

R implementation and documentation: Abulaziz Alenazi \email{a.alenazi@nbu.edu.sa}.
}

\examples{
set.seed( 1 )
data <- matrix(rnorm(500 * 30), ncol = 30)
FS <- sample( c( 0.1, 0.5, 0.7, NA ), ncol( data ), replace = TRUE)
m_ng(y = rnorm( 500 ), data = data, FS = FS)
}
