% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmCreateManagedServer}
\alias{chmCreateManagedServer}
\title{Create an ngchmServer object for a managed NG-CHM server}
\usage{
chmCreateManagedServer(
  serverName,
  privateAddr,
  publicAddr = NULL,
  chmPort = 80,
  managerPort = 18080,
  serviceName = "default",
  ...
)
}
\arguments{
\item{serverName}{The name of the new server object.}

\item{privateAddr}{Private IP name/address of the server.}

\item{publicAddr}{Public IP name/address of the server.}

\item{chmPort}{Port on which the chm viewer is listening.}

\item{managerPort}{Port on which the chm manager is listening.}

\item{serviceName}{Name of the chmManager service}

\item{...}{Additional options passed to chmCreateServer}
}
\value{
The created (and registered) ngchmServer object.
}
\description{
Create an ngchmServer object called 'serverName' (see details).
The new ngchmServer object is returned and registered so that it can be
referenced by name, including retrieval using chmServer.
This library will communicate with the NG-CHM using the private address.
Returned URLs for viewing NG-CHMs will use the public address.
}
\seealso{
\code{\link[=chmServer]{chmServer()}}

\code{\link[=chmCreateServer]{chmCreateServer()}}
}
