% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological_indices.R
\name{cal.NCR}
\alias{cal.NCR}
\alias{cal.NCR.data.frame}
\alias{cal.NCR.matrix}
\alias{cal.NCR.default}
\title{Calculate Nematode Channel Ratio (NCR)}
\usage{
cal.NCR(data, ...)

\method{cal.NCR}{data.frame}(data, ...)

\method{cal.NCR}{matrix}(data, ...)

\method{cal.NCR}{default}(data, ...)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematode genera.
Each element indicates the count of a specific nematode genus in the corresponding sample. Row names must be sample names, and column names must be nematode genus names.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data frame with two columns:
\item{Sample.ID}{Character vector of sample identifiers (from row names of \code{data})}
\item{NCR}{Nematode Channel Ratio for each sample}
}
\description{
This function calculates the Nematode Channel Ratio (NCR) for ecological communities.
}
\examples{
# Example with a data frame
df <- data.frame(
  Cephalobus = c(10, NA, 15),
  Caenorhabditis = c(5, 10, NA),
  Pratylenchus = c(8, 12, 10),
  row.names = c("A", "B", "C")
)
cal.NCR(data = df)
}
