% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separation_Significance.R
\name{separation_Significance}
\alias{separation_Significance}
\title{Separation Significance}
\usage{
separation_Significance(G, ST, Threads = 2, N = 1000, correct_by_target = TRUE)
}
\arguments{
\item{G}{The original graph (often an interactome / PPI).}

\item{ST}{Set-Target data. It is a data.frame with two columns. ID and Target.}

\item{Threads}{How many threads you'd like to use (for parallel computation).}

\item{N}{default to 1000. The number of permutations}

\item{correct_by_target}{TRUE by default. If you want to use the set of targets for the permutation or the full network.}
}
\value{
the separation and distance of modules and its p-value.
}
\description{
Calculates the separation of two set of targets on a network and assigns a p-value to it.
Often used to measure separation of disease modules in a interactome.
Separation is calculated as in Menche, J. et al (2015) <doi:10.1126/science.1257601>.
p-values are calculates based on the permutation of nodes, you can set the full network to be
in the set for permutation or can select the ones you include as input.
}
\examples{
set.seed(12)
require(magrittr)
x = data.frame(n1 = sample(LETTERS[1:5]),
               n2 =  sample(LETTERS[1:20]))

D1 = data.frame(gene = c("H", "I", "S", "N", "A"), disease = "D1")
D2 = data.frame(gene = c("E", "C",  "R" , "J", "Q", "O"), disease = "D2")
D3 = data.frame(gene = c("E", "G", "T", "P"), disease = "D3")
D4 = data.frame(gene = c("A", "B", "E"), disease = "D4")
D5 = data.frame(gene = c("D", "F", "L"), disease = "D5")
D6 = data.frame(gene = c("D", "F", "K"), disease = "D6")
D7 = data.frame(gene = c("A", "B" ,"F", "K"), disease = "D7")

Diseases = rbind(D1, D2, D3, D4, D5, D6, D7)
Diseases \%<>\% dplyr::select(disease, gene)
g = igraph::graph_from_data_frame(x, directed = FALSE)
g = igraph::simplify(g)

separation_Significance(G = g,
ST = Diseases,
correct_by_target = FALSE,
Threads = 2)
}
