% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictTree.R
\name{predictTree}
\alias{predictTree}
\title{Predict Treatment Outcomes with a Trained Decision Tree}
\usage{
predictTree(tree, PatientData, PatientSensitivityTrain)
}
\arguments{
\item{tree}{A trained decision tree object created by the `trainTree` function.}

\item{PatientData}{A matrix representing patient features, where rows correspond to patients/samples
and columns correspond to genes/features. This matrix can contain:
\itemize{
  \item Binary mutation data (e.g., presence/absence of mutations).
  \item Continuous data from gene expression profiles (e.g., expression levels).
}}

\item{PatientSensitivityTrain}{A matrix containing the drug response values of the **training dataset**. 
In this matrix, rows correspond to patients, and columns correspond to drugs. 
This matrix is used solely for extracting treatment names and is not 
used in the prediction process itself.}
}
\value{
A factor representing the assigned treatment for each node in the
decision tree based on the provided patient data and sensitivity.
}
\description{
This function utilizes a trained decision tree model (ODT) to predict treatment
outcomes for test data based on patient sensitivity data and features, such as
mutations or gene expression profiles.
}
\examples{
\donttest{
  # Example 1: Prediction using mutation data
  data("mutations_w12")
  data("mutations_w34")
  data("drug_response_w12")
  ODTmut <- trainTree(PatientData = mutations_w12, 
                      PatientSensitivity = drug_response_w12, 
                      minbucket = 10)
  ODTmut
  ODT_mutpred <- predictTree(tree = ODTmut, 
                              PatientSensitivityTrain = drug_response_w12, 
                              PatientData = mutations_w34)

  # Example 2: Prediction using gene expression data
  data("expression_w34")
  data("expression_w12")
  data("drug_response_w34")
  ODTExp <- trainTree(PatientData = expression_w34, 
                       PatientSensitivity = drug_response_w34, 
                       minbucket = 20)
  ODTExp
  ODT_EXPpred <- predictTree(tree = ODTExp, 
                              PatientSensitivityTrain = drug_response_w34, 
                              PatientData = expression_w12)
}

}
