% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{test.once.flat}
\alias{test.once.flat}
\title{test single change point for matrix-valued online time series -''flat''
version}
\usage{
test.once.flat(
  Y,
  k = 1,
  m = ceiling(max(20, (dim(Y)[3])^(r/(r + 2)))),
  epsilon = 0.05,
  r = 8,
  decrease = 0,
  method = "ps",
  eta = 0.25,
  cv = 2.386
)
}
\arguments{
\item{Y}{data, a \eqn{T\times p1\times p2} array.}

\item{k}{a positive integer indicating which eigenvalue to monitor.
\eqn{k=1} for the largest eigenvalue.}

\item{m}{a positive integer (\eqn{>1}) indicating the bandwidth of the
rolling windom.}

\item{epsilon}{the rescaling parameter taking value in \eqn{(0,1)}; see He
et al. (2021).}

\item{r}{a positive integer indicating the order of the transformation
function \eqn{g(x)=|x|^r}; see also  \code{\link{gen.psi.tau.proj}}.}

\item{decrease}{a logical value. If \emph{decrease=1}, testing the
decrease of factor number.}

\item{method}{indicating the test statistic, ``ps'' for the partial-sum
method; others for the worst-case method.}

\item{eta}{a number between \eqn{[0,1)}, indicating the parameter \eqn{\eta}
used in the partial-sum statistic.}

\item{cv}{critical value; see also  \code{\link{test.once.psi}}.}
}
\value{
a list containing:
\item{test}{a logical value. 1 indicating the existence of change point, 0
indicating no change point.} \item{loc}{an integer larger than m, indicating
the location of change point; or \eqn{NA} when no change point is reported.}
}
\description{
This function tests single change point for matrix-valued online time
series, under a two-way factor structure, using ''flat'' sample covariance
matrix.
}
\details{
See He et al. (2021).
}
\examples{

k1=3
k2=3
epsilon=0.05
Sample_T=50
p1=40
p2=20
r=8
m=p2

# generate data
Y=gen.data(Sample_T,p1,p2,k1,k2,tau=0.5,change=1,pp=0.5)

# calculate cv for "ps" with eta=0.45 and "wc"
cv1=getcv(0.05,method="ps",eta=0.45)
cv2=getcv(0.05,method="wc")


## test with Y, flat version
test.once.flat(Y,k1+1,m,epsilon,r,0,method="ps",eta=0.25)


test.once.flat(Y,k1+1,m,epsilon,r,0,method="ps",eta=0.45,cv1)


test.once.flat(Y,k1+1,m,epsilon,r,0,method="wc",eta=0.5,cv2)

}
\references{
He Y, Kong X, Trapani L, & Yu L(2021). Online change-point detection for
matrix-valued time series with latent two-way factor structure. \emph{arXiv
preprint}, arXiv:2112.13479.
}
\author{
Yong He, Xinbing Kong, Lorenzo Trapani, Long Yu
}
