% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_regfunctions.R
\name{ASE_reg}
\alias{ASE_reg}
\title{The ASE function for the local linear estimator (LLE) in the regression context.}
\usage{
ASE_reg(h, desx, y, rx)
}
\arguments{
\item{h}{numerical vector of bandwidth values,}

\item{desx}{numerical vecror of design points,}

\item{y}{numerical vecror of data points corresponding to the design points \eqn{desx},}

\item{rx}{numerical vecror of values of the regression function at \eqn{desx}.}
}
\value{
The vector of values of \eqn{ASE(h)} for the correponsing vector of \eqn{h} values.
}
\description{
Computing \eqn{ASE(h)}, the value of the ASE function for the local linear estimator in the regression context, for the given vector of \eqn{h} values.
}
\details{
The average squared error (ASE) is used as a measure of performace of the local linear estimator based on the Gaussian kernel.
}
\examples{
\dontrun{
# Example (ASE function for a random sample of size n=100 generated from the function reg3 that
# has six cusps. The function originates from the article of Savchuk et al. (2013).
# The level of the added Gaussian noise is sigma=1/1000).
n=100
dx=(1:n-0.5)/n
regx=reg3(dx)
ydat=regx+rnorm(n,sd=1/1000)
harray=seq(0.003,0.05,len=300)
ASEarray=ASE_reg(harray,dx,ydat,regx)
hmin=round(h_ASE_reg(dx,ydat,regx),digits=4)
dev.new()
plot(harray,ASEarray,'l',lwd=3,xlab="h",ylab="ASE",main="ASE function for a random sample
from r3",cex.lab=1.7,cex.axis=1.7,cex.main=1.5)
legend(0.029,0.0000008,legend=c("n=100","sigma=1/1000"),cex=1.7,bty="n")
legend(0.005,0.000002,legend=paste("h_ASE=",hmin),cex=2,bty="n")
}
}
\references{
Hart, J.D. and Yi, S. (1998) One-sided cross-validation. \emph{Journal of the American Statistical Association}, 93(442), 620-631.
}
\seealso{
\code{\link{loclin}}, \code{\link{h_ASE_reg}}, \code{\link{CV_reg}}, \code{\link{OSCV_reg}}.
}
