% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preferred_poles.R
\name{alignByPreferredPole}
\alias{alignByPreferredPole}
\title{Align constructs by preferred pole}
\usage{
alignByPreferredPole(x, side_positive = "right")
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{side_positive}{Align all positoive poles on '}
}
\value{
A \code{repgrid} object with aligned constructs.
}
\description{
The direction of the constructs in a grid is arbitrary. While their reversal (see \code{\link[=reverse]{reverse()}}) does not affect the information
contained in the grid, it is often useful to align constructs for easier interpretation. One way of alignment
is placing all positive poles on the same side. Note that this this is only possible if the preferred poles
are defined (see \code{\link[=preferredPoles]{preferredPoles()}}).
}
\examples{
x <- preferredPolesByIdeal(boeker, "ideal self")
x <- alignByPreferredPole(x)
x
}
\seealso{
Aligning constructs
\code{\link{alignByIdeal}()},
\code{\link{alignByLoadings}()}
}
\concept{align_constructs}
