% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbeConvert.R
\name{probeConvert}
\alias{probeConvert}
\title{probeConvert}
\usage{
probeConvert(exprMatrix, probeMerge = FALSE, mergeBy = "mean")
}
\arguments{
\item{exprMatrix}{A expression matrix is required. Row names of the matrix should be the microarray probe ID.}

\item{probeMerge}{A instruction is needed. If probeMerge = F, the multiple probes for one gene will not be merged. If probeMerge = T, the multiple probes for one gene will be merged. The default value is F.}

\item{mergeBy}{A method for merging multiple probes for one gene if probeMerge = T. Mean, max and min value is available.}
}
\value{
A matrix.
}
\description{
Convert rice microarray probe ID to RAP-DB ID and merge multiple probes for one gene
}
\examples{
\donttest{
expr <- system.file("test_file", header = TRUE, sep="\t", header=TRUE, stringsAsFactors = FALSE)
formatted_expr <- probeConvert(exprMatrix = expr)
formatted_expr1 <- probeConvert(exprMatrix = expr, probeMerge = TRUE)
}
}
