% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_to_vector.R
\name{transform_to_vector}
\alias{transform_to_vector}
\title{transform_to_vector}
\usage{
transform_to_vector(data)
}
\arguments{
\item{data}{Input data that will be transformed into a vector}
}
\value{
Data formatted as a vector
}
\description{
Transform any type of data to a vector
}
\examples{
numeric_data = c(1, 2, 3)
character_data = c("a", "b", "c")
logical_data = c(TRUE, FALSE, TRUE)
factor_data = factor(c("A", "B", "A"))
integer_data = as.integer(c(1, 2, 3))
complex_data = complex(real = c(1, 2, 3), imaginary = c(4, 5, 6))
list_data = list(1, "apple", TRUE)
data_frame_data = data.frame(x = c(1, 2, 3), y = c("a", "b", "c"))

transformed_numeric = transform_to_vector(numeric_data)
transformed_character = transform_to_vector(character_data)
transformed_logical = transform_to_vector(logical_data)
transformed_factor = transform_to_vector(factor_data)
transformed_integer = transform_to_vector(integer_data)
transformed_complex = transform_to_vector(complex_data)
transformed_list = transform_to_vector(list_data)
transformed_data_frame = transform_to_vector(data_frame_data)

}
\author{
Andres Missiego Manjon
}
