% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipsesPlotPCRA.covfm.R
\name{ellipsesPlotPCRA.covfm}
\alias{ellipsesPlotPCRA.covfm}
\title{Overlaid Correlations Ellipses Plots}
\usage{
ellipsesPlotPCRA.covfm(x, ...)
}
\arguments{
\item{x}{a `covfm` object}

\item{...}{additional arguments are ignored.}
}
\value{
x is invisibly returned
}
\description{
When there are 3 or more variables in the data, this 
function produces a matrix with overlaid ellipses drawn in the upper
triangle. The main use case is a sample covariance estimator and a
robust covariance matrix estimator, so two overlaid ellipses. The
ellipses in cell i,j of the plot is drawn to be a contour of a 
standard bivariate normal density with correlation `rho(i,j)`. Two
ellipses are drawn in each cell, one for the sample covariance matrix
estimate and one for the robust covariance matrix estimate. When there
are only 2 variables in the data, this function produces a scatter plot
of the data with overlaid 95% confidence ellipses for the sample and
robust covariance matrix estimates in the `covfm` object. The lower 
triangle displays the sample correlation estimate value in red font,
and robust correlation estimate in black font.
}
\examples{
args(ellipsesPlotPCRA.covfm)
}
\author{
The original version `ellipsesPlot.covfm was wirtten by Kjell
Konis for the `fit.models` package.  This version, modified by Doug
Martin, uses thicker lines for the ellipses, with red color for the
sample correlation and black for the robust correlation, for a better
overall visual display.
}
