% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt.outputMvoPCRA.R
\name{opt.outputMvoPCRA}
\alias{opt.outputMvoPCRA}
\title{Optimal Portfolio Weights and Performance}
\usage{
opt.outputMvoPCRA(
  opt,
  returns,
  digits = NULL,
  itemNames = NULL,
  annualize = TRUE,
  frequency = "monthly",
  rf = 0
)
}
\arguments{
\item{opt}{List output of `optimize.portfolio`}

\item{returns}{Multivariate xts object of portfolio assets returns}

\item{digits}{Integer number of significant digits with default NULL}

\item{itemNames}{character vector of use-supplied names for portfolio
weights, mean, standard deviation and Sharpe Ratio}

\item{annualize}{Logical with default TRUE}

\item{frequency}{Returns frequency: "monthly", "weekly" or "daily", with 
default "monthly"}

\item{rf}{Numeric value of risk-free rate with default 0.0}
}
\value{
A list containing the portfolio numeric weights, mean value,
standard deviation and Sharpe Ratio, with default names Wgts, Mean, 
StdDev, and SR, or user-supplied names as a character vector value for
the argument `itemNames`.
}
\description{
Converts output of PortfolioAnalytics function
optimize.portfolio, which computes a minimum variance portfolio,
to a list containing the portfolio weights vector, mean, volatility
and Sharpe Ratio.

Converts output of `optimize.portfolio` to a list of the
portfolio weights, mean, volatility and Sharpe Ratio.
}
\details{
This function uses the weights returned by optimize.portfolio,
along with the portfolio monthly, weekly or daily assets returns, and a
risk-free rate, to compute the portfolio mean return, volatility, and
Sharpe Ratio.  By default the latter three are annualized, but the user
may choose to return non-annualized performance values.
}
\examples{
args(opt.outputMvoPCRA)
}
\author{
R. Douglas Martin
}
