% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hookreg.R
\name{hookreg}
\alias{hookreg}
\title{A function to calculate the slope and intercept of an amplification curve data
from a quantitative PCR experiment at the end of the data stream.}
\usage{
hookreg(
  x,
  y,
  normalize = TRUE,
  sig.level = 0.0025,
  CI.level = 0.9975,
  robust = FALSE
)
}
\arguments{
\item{x}{is the cycle numbers (x-axis).}

\item{y}{is the cycle dependent fluorescence amplitude (y-axis).}

\item{normalize}{is a logical parameter indicating if the data should be
normalized to the 0.999 quantile}

\item{sig.level}{defines the significance level to test for a significant
regression}

\item{CI.level}{confidence level required for the slope}

\item{robust}{is a logical parameter indicating if the data should be
analyzed be a robust linear regression (\code{lmrob}).}
}
\value{
gives a \code{numeric} (S3 class, type of \code{double}) as output 
for the detection of a hook
}
\description{
\code{hookreg} is a function to calculate the slope and intercept of an
amplification curve data from a quantitative PCR experiment. The idea is that
a strong negative slope at the end of an amplification curve is indicative for
a hook effect (see Barratt and Mackay 2002).
}
\examples{
library(qpcR)

default.par <- par(no.readonly = TRUE)
# Calculate slope and intercept on noise (negative) amplification curve data
# for the last eight cycles.
res_hook <- data.frame(sample=colnames(boggy)[-1], 
                       t(sapply(2:ncol(boggy), function(i) {
                       hookreg(x=boggy[, 1], y=boggy[, i])})))
res_hook

data_colors <- rainbow(ncol(boggy[, -1]), alpha=0.5)
cl <- kmeans(na.omit(res_hook[, 2:3]), 2)$cluster

par(mfrow=c(1,2))
matplot(x=boggy[, 1], y=boggy[, -1], xlab="Cycle", ylab="RFU",
 main="boggy Data Set", type="l", lty=1, lwd=2, col=data_colors)
 legend("topleft", as.character(res_hook$sample), pch=19,
         col=data_colors, bty="n")

plot(res_hook$intercept, res_hook$slope, pch=19, cex=2, col=data_colors,
 xlab="intercept", ylab="Slope",
 main="Clusters of Amplification Curves with an Hook Effect-like Curvature\nboggy Data Set")
 points(res_hook$intercept, res_hook$slope, col=cl, pch=cl, cex=cl)
 legend("topright", c("Strong Hook effect", " Weak Hook effect"), pch=c(1,2), col=c(1,2), bty="n")
 text(res_hook$intercept, res_hook$slope, res_hook$sample)

par(default.par)
}
\references{
K. Barratt, J.F. Mackay, \emph{Improving Real-Time PCR Genotyping
Assays by Asymmetric Amplification}, J. Clin. Microbiol. 40 (2002) 1571--1572.
doi:10.1128/JCM.40.4.1571-1572.2002.
}
\author{
Stefan Roediger, Michal Burdukiewcz
}
\keyword{hook}
\keyword{intercept}
\keyword{slope}
