% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/31_U_SHAPE.R
\name{ush.bin}
\alias{ush.bin}
\title{U-shape binning algorithm}
\usage{
ush.bin(
  x,
  y,
  knot,
  method,
  sc = c(NA, Inf, -Inf, NaN),
  sc.method = "together",
  g = 20,
  min.pct.obs = 0.05,
  min.avg.rate = 0.01,
  p.val = 0.05,
  woe.trend = TRUE,
  woe.gap = 0.1
)
}
\arguments{
\item{x}{Numeric vector to be binned.}

\item{y}{Numeric target vector (binary).}

\item{knot}{Numeric value of selected knot. Usually the results of \code{\link{ush.test}} function.}

\item{method}{Binning method. Available options are all from monobin package:
\code{"cum.bin", "iso.bin", "ndr.bin", "pct.bin", "sts.bin", "woe.bin", "mdt.bin"}.}

\item{sc}{Numeric vector with special case elements. Default values are \code{c(NA, NaN, Inf, -Inf)}.
Recommendation is to keep the default values always and add new ones if needed. Otherwise, if these values exist
in \code{x} and are not defined in the \code{sc} vector, function can report the error.}

\item{sc.method}{Define how special cases will be treated, all together or separately.
Possible values are \code{"together", "separately"}.}

\item{g}{Number of starting groups. Only needed for \code{"cum.bin"}, \code{"pct.bin"} and \code{mdt.bin} methods. Default is 20.}

\item{min.pct.obs}{Minimum percentage of observations per bin. Default is 0.05 or 30 observations.}

\item{min.avg.rate}{Minimum \code{y} average rate. Default is 0.05 or 30 observations.}

\item{p.val}{Threshold for p-value. Only needed for \code{"sts.bin"} and \code{"ndr.bin"} methods.
Default is 0.05.}

\item{woe.trend}{Logical. Only needed for \code{"pct.bin"} method with default \code{TRUE}.}

\item{woe.gap}{Minimum WoE gap between bins. Only needed for \code{"woe.bin"} method with default of 0.1.}
}
\value{
The command \code{ush.bin} generates a list of two objects. The first object, data frame \code{summary.tbl}
presents a summary table of final binning, while \code{x.trans} is a vector of discretized values.
}
\description{
\code{ush.bin} performs U-shape binning. All algorithms from \href{https://CRAN.R-project.org/package=monobin}{monobin}
package are available. Due to specific nature of
binning algorithms it is possible that for some selected knots algorithm will not be able to find U-shape. Therefore,
users are encourage to inspect the results more into details and to try different binning algorithms.
}
\examples{
res <- ush.bin(x = gcd$amount, y = gcd$qual, knot = 2992.579, method = "ndr.bin")
res[[1]]
plot(res[[1]]$dr, type = "l")
}
