% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/31_U_SHAPE.R
\name{ush.test}
\alias{ush.test}
\title{Testing for U-shape relation}
\usage{
ush.test(
  x,
  y,
  p.value = 0.05,
  min.pct.obs = 0.05,
  min.pct.def = 0.01,
  g = 20,
  sc = c(NA, Inf, -Inf, NaN)
)
}
\arguments{
\item{x}{Numeric vector to be tested for U-shape.}

\item{y}{Numeric target vector (binary).}

\item{p.value}{Threshold for p-value of statistical significance of the estimated coefficients
next to basis functions. Default is 0.05.}

\item{min.pct.obs}{Minimum percentage of observations per bin. Default is 0.05.}

\item{min.pct.def}{Minimum \code{y} average rate. Default is 0.01 or minimum 1 bad case for y 0/1.}

\item{g}{Number of knots used for testing the U-shape (integer). It should take values between 2 and 50 with
default value of 20.}

\item{sc}{Numeric vector with special case elements. Default values are \code{c(NA, NaN, Inf, -Inf)}.
Recommendation is to keep the default values always and add new ones if needed. Otherwise, if these values exist
in \code{x} and are not defined in the \code{sc} vector, function can report the error.}
}
\value{
The command \code{ush.test} returns list of three objects. The first object (\code{candidates})
is the data frame with summary of tested candidate knots. Using the reported results of this data frame
user can conclude if U-shape exists at all (column where \code{direction} is equal to \code{TRUE}) and
check its statistical significance (column \code{significance} - \code{TRUE, FALSE}).
The second object (\code{optimal}) reports optimal knot value (if exists).
It is selected as the knot with minimum deviance among all candidates for
which \code{direction} and \code{significance} are equal to \code{TRUE}.
The last, third, object (\code{basis.functions}) exports basis functions for optimal knot. Basis functions
will be exported only in case optimal knot is found. \cr
If optimal knot is not found, then users are encouraged to inspect closer the results of candidate testing.
}
\description{
\code{ush.test} performs U-shape testing between the target and analyzed risk factor.
Testing is based on B-splines basis functions and change of the sign of the estimated coefficients.
}
\examples{
data(gcd)
res <- ush.test(x = gcd$amount, y = gcd$qual)
res 
#optimal knot is not found so candidate can be defined as follows:
direction.t <- res$candidate[res$candidate$direction, ]
optimal.k <- direction.t$cp[direction.t$deviance\%in\%min(direction.t$deviance)]
optimal.k
}
