% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PHcluster.R
\name{PHcluster}
\alias{PHcluster}
\title{Poisson hurdle clustering}
\usage{
PHcluster(
  data,
  Treatment,
  nK,
  method = c("EM", "SA"),
  absolute = FALSE,
  cool = 0.9,
  nstart = 1
)
}
\arguments{
\item{data}{Data matrix with dimension N*P indicating N features and P samples. The cluster analysis is done feature-wised.}

\item{Treatment}{Vector of length P. Indicating replicates of different treatment groups. For example, \emph{Treatment} = c(1,1,2,2,3,3) indicates 3 treatment groups, each with 2 replicates.}

\item{nK}{Positive integer. Number of clusters.}

\item{method}{Method for the algorithm. Can choose between \emph{"EM"} as Expectation Maximization or \emph{"SA"} as Simulated Annealing.}

\item{absolute}{Logical. Whether we should use absolute (TRUE) or relative (False) abundance of features to determine clusters.}

\item{cool}{Real number between (0, 1). Cooling rate for the \emph{"SA"} algorithm. Uses 0.9 by default.}

\item{nstart}{Positive integer. Number of starts for the entire algorithm. Note that as \emph{nstart} increases the computational time also grows linearly. Uses 1 by default.}
}
\value{
\describe{
\item{cluster}{Vector of length N consisting of integers from 1 to nK. Indicating final clustering result. For evaluating the clustering result please check \link[aricode]{NMI} for \emph{Normalized Mutual Information}.}
\item{prob}{N*nK matrix. The (i, j)th element representing the probability that observation i belongs to cluster j.}
\item{log_l}{Scaler. The Poisson hurdle log-likelihood of the final clustering result.}
\item{alpha}{Vector of length N. The geometric mean abundance level for each feature, across all treatment groups.}
\item{Normalizer}{vector of length P. The normalizing constant of sequencing depth for each sample.}
}
}
\description{
This function gives the clustering result based on a Poisson hurdle model.
}
\examples{
######## Run the following codes in order:
##
## This is a sample data set which has 100 features, and 4 treatment groups with 4 replicates each.
data('sample_data')
head(sample_data)
set.seed(1)
##
## Finding the optimal number of clusters
K <- Hybrid(sample_data, Kstart = 4, Treatment = rep(c(1,2,3,4), each = 4))
##
## Clustering result from EM algorithm
result <- PHcluster(sample_data, rep(c(1,2,3,4), each = 4), K, method = 'EM', nstart = 1)
print(result$cluster)
##
## Plot the feature abundance level for each cluster
plot_abundance(result, sample_data, Treatment = rep(c(1,2,3,4), each = 4))
}
