% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.all.R
\name{pk.nca.intervals}
\alias{pk.nca.intervals}
\title{Compute NCA for multiple intervals}
\usage{
pk.nca.intervals(
  data_conc,
  data_dose,
  data_intervals,
  sparse,
  options,
  impute,
  verbose = FALSE
)
}
\arguments{
\item{data_conc}{A data.frame or tibble with standardized column names as
output from \code{prepare_PKNCAconc()}}

\item{data_dose}{A data.frame or tibble with standardized column names as
output from \code{prepare_PKNCAdose()}}

\item{data_intervals}{A data.frame or tibble with standardized column names
as output from \code{prepare_PKNCAintervals()}}

\item{sparse}{Should only sparse calculations be performed (TRUE) or only
dense calculations (FALSE)?}

\item{options}{List of changes to the default PKNCA options (see
\code{PKNCA.options()})}

\item{impute}{The column name in \code{data_intervals} to use for imputation}

\item{verbose}{Indicate, by \code{message()}, the current state of calculation.}
}
\value{
A data.frame with all NCA results
}
\description{
Compute NCA for multiple intervals
}
