% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_calc.R
\name{time_calc}
\alias{time_calc}
\title{Times relative to an event (typically dosing)}
\usage{
time_calc(time_event, time_obs, units = NULL)
}
\arguments{
\item{time_event}{A vector of times for events}

\item{time_obs}{A vector of times for observations}

\item{units}{Passed to \code{base::as.numeric.difftime()}}
}
\value{
A data.frame with columns for:
\describe{
\item{event_number_before}{The index of \code{time_event} that is the last one before \code{time_obs} or \code{NA} if none are before.}
\item{event_number_after}{The index of \code{time_event} that is the first one after \code{time_obs} or \code{NA} if none are after.}
\item{time_before}{The minimum time that the current \code{time_obs} is before a \code{time_event}, 0 if at least one \code{time_obs == time_event}.}
\item{time_after}{The minimum time that the current \code{time_obs} is after a \code{time_event}, 0 if at least one \code{time_obs == time_event}.}
\item{time_after_first}{The time after the first event (may be negative or positive).}
}

\code{time_after} and \code{time_before} are calculated if they are at the same time as
a dose, they equal zero, and otherwise, they are calculated relative to the
dose number in the \verb{event_number_*} columns.
}
\description{
Times relative to an event (typically dosing)
}
