% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.R
\name{balance}
\alias{balance}
\title{Checking covariate balance based on estimated cluster assignment probabilities (principal score) and treatment assignment probabilities (propensity score).}
\usage{
balance(data_in, atekCl_results, covariate_names = "X_dat.1", ttname, Kname)
}
\arguments{
\item{data_in}{A \code{data.frame} containing all necessary variables.}

\item{atekCl_results}{[\code{list}]\cr
A list returned from the R function \code{atekCl()}.}

\item{covariate_names}{[\code{character}]\cr
A character vector of the column names of the baseline covariates for checking balance.}

\item{ttname}{[\code{character}]\cr
A character string of the column name of the treatment variable. The treatment variable should be dummy-coded, with 1 for the (clustered) treatment arm and 0 for the (non-clustered) control arm.}

\item{Kname}{[\code{character}]\cr
A character string of the column name of the cluster assignment variable. This variable should be coded as 0 for individuals in the control arm, the arm without the cluster assignment.}
}
\value{
A \code{data.frame} containing the covariate balance measures (smd, standardized mean difference) between each cluster in the treatment arm and the control arm, both before and after the weighting adjustment.
}
\description{
Checking covariate balance based on estimated cluster assignment probabilities (principal score) and treatment assignment probabilities (propensity score).
}
