test_that("correct POV results", {
  ExpectedOut <- structure(list(
    Variance = c(
      0.00322530864197531, 0.000344650205761315,
      0.00179526748971194, 0.00108539094650206, 0.0424845679012346,
      0.00513917639259226, 0.0302773058569813, 0.00706808565166098,
      0, 0.0457098765432099
    ), StdDev = c(
      0.056791800834058, 0.0185647570886698,
      0.0423705969949909, 0.0329452719901059, 0.206117849545435, 0.071688049161574,
      0.174003752422128, 0.0840719076247291, 0, 0.213798682276598
    ),
    `% of total` = c(
      7.05604321404457, 0.753995048390724, 3.92752644609498,
      2.37452171955885, 92.9439567859554, 11.243032756245, 66.2379952576769,
      15.4629287720335, 0, 100
    )
  ), class = "data.frame", row.names = c(
    "Between Total",
    "  Between Machine", "  Between Metrology", "  Between Machine:Metrology",
    "Within Total", "  Within Machine", "  Within Metrology", "  Within Machine:Metrology",
    "  Common", "Total"
  ))
  dt <- structure(list(Machine = c(
    "A", "A", "A", "A", "A", "A", "A",
    "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "B", "B",
    "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B", "B",
    "B", "B", "B", "C", "C", "C", "C", "C", "C", "C", "C", "C", "C",
    "C", "C", "C", "C", "C", "C", "C", "C"
  ), Metrology = c(
    "A", "A",
    "A", "A", "A", "A", "B", "B", "B", "B", "B", "B", "C", "C", "C",
    "C", "C", "C", "A", "A", "A", "A", "A", "A", "B", "B", "B", "B",
    "B", "B", "C", "C", "C", "C", "C", "C", "A", "A", "A", "A", "A",
    "A", "B", "B", "B", "B", "B", "B", "C", "C", "C", "C", "C", "C"
  ), Response = c(
    0.5, 0.55, 0.4, 1.05, 1, 1, 0.8, 0.8, 0.8, 0.8,
    0.8, 0.8, 0.45, 0.5, 0.45, 1, 1.05, 1.05, 0.65, 0.6, 0.6, 1,
    1.1, 0.95, 0.85, 0.8, 0.95, 0.85, 0.95, 0.95, 0.55, 0.45, 0.65,
    1, 0.7, 0.75, 0.55, 0.55, 0.55, 1.05, 0.95, 1, 0.8, 0.75, 0.75,
    0.8, 0.75, 0.75, 0.4, 0.4, 0.4, 1, 1.05, 1.05
  )), class = "data.frame", row.names = c(
    NA,
    -54L
  ))

  expect_equal(POV(Response ~ Machine * Metrology, dt, Complete = TRUE), ExpectedOut)
})
