% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDP_EEDP_MEDP.R
\name{EDP_EEDP_MEDP}
\alias{EDP_EEDP_MEDP}
\title{EDP_EEDP_MEDP feature vector}
\usage{
EDP_EEDP_MEDP(pssm_name)
}
\arguments{
\item{pssm_name}{is name of PSSM Matrix  file}
}
\value{
a list of three feature vectors (EDP, EEDP, MEDP)
}
\description{
these are three feature vectors (EDP, EEDP, MEDP) which are used for prediction of protein
structural class for low-similarity sequences.at first ED-PSSM Matrix with 20*20 dimensions
is constructed from PSSM Matrix then by using this Matrix, EDP and EEDP vectors are
obtained eventually MEDP feature vector is obtained by fusing these vectors.
}
\examples{
X<-EDP_EEDP_MEDP(paste0(system.file("extdata",package="PSSMCOOL"),"/C7GS61.txt.pssm"))
}
\references{
Zhang, L., Zhao, X. and Kong, L. (2014) Predict protein structural class for low-similarity sequences by evolutionary difference
information into the general form of Chou's pseudo amino acid composition, Journal of Theoretical Biology, 355, 105-110.
}
