% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSSM_AC.R
\name{pssm_ac}
\alias{pssm_ac}
\title{auto covariance transformation feature vector}
\usage{
pssm_ac(pssm_name, lg = 10)
}
\arguments{
\item{pssm_name}{name of the PSSM Matrix file}

\item{lg}{a parameter which indicates distance between two residues}
}
\value{
feature vector which its length depends on parameter lg. by default lg is 10 hence feature vector
would be of length 200.
}
\description{
The AC variable measures the correlation of the same property between two residues
separated by a distance of lg along the sequence
}
\note{
in use of this function The lg parameter must be less than the length of the smallest sequence
in the database.
}
\examples{
X<-pssm_ac(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
Dong, Q., Zhou, S. and Guan, J. (2009) A new taxonomy-based protein fold recognition approach
based on autocross-covariance transformation, Bioinformatics, 25, 2655-2662.
}
