% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wam.pl.R
\name{wam.pl}
\alias{wam.pl}
\title{Piecewise-Linear Weber and Morris Intraparticle Diffusion Model}
\usage{
wam.pl(t, qt)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t}
}
\value{
the piecewise-linear regression and the parameter estimation for the Weber and Morris Intraparticle Diffusion Model
}
\description{
The Weber and Morris Intraparticle Diffusion Model is a multi-linear sorption process in which the intraparticle diffusion process is the limiting factor, where other interaction mechanisms such as adsorption on the external surface and diffusion into the interior may be happening simultaneously (Campos, Barbosa, Rodriguez-Diaz, and Duarte, 2018).
}
\examples{
t <- c(0,15,30,45,60,75,90,105,120)
qt <-c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
wam.pl(t,qt)
}
\references{
Weber, W.J. and Morris, J.C. (1963) Kinetics of Adsorption on Carbon from Solutions. Journal of the Sanitary Engineering Division, American Society of Civil Engineers, 89, 31-60.

Campos, N. F., Barbosa, C. M. B. M., Rodriguez-Diaz, J. M., &; Duarte, M. M. M. B. (2018) <doi:10.1177/0263617418773844> Removal of naphthenic acids using activated charcoal: Kinetic and equilibrium studies. Adsorption Science and Technology, 36(7-8), 1405-1421.
}
\author{
Jeff Ryan S. Magalong

Joshua Z. Dela Cruz

Jeann M. Bumatay

Chester C. Deocaris
}
