% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IgleChiMSI.R
\name{IgleChiMSI}
\alias{IgleChiMSI}
\title{Iglesias-Chirife Moisture Sorption Isotherm}
\usage{
IgleChiMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Iglesias-Chirife Moisture Sorption Isotherm model.
}
\description{
Iglesias-Chirife Isotherm is an an empirical equation for describing water sorption behavior of various fruits and other sugar-rich foods.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
IgleChiMSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Chirife, J., & Iglesias, H. A. (1978) <doi:10.1111/j.1365-2621.1978.tb00792.x> Equations for fitting water sorption isotherms of foods: Part 1 - A review. International Journal of Food Science & Technology, 13(3), 159-174.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
