\name{PVR-class}
\Rdversion{1.1}
\docType{class}
\alias{PVR-class}
\alias{show,PVR-method}

\title{Class \code{"PVR"}}
\description{
A S4 class that contains eigenvalues and eigenvectors from decomposition of a phylogenetic distance matrix and PVR r squared and residuals.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("PVR", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{Eigen}:}{Object of class \code{"list"} that contains the eigenvalues and eigenvectors generated by phylogenetic distance matrix eigendecomposition.}
    \item{\code{phyDist}:}{Object of class \code{"matrix"} that contains a phylogenetic distance matrix.}
    \item{\code{phylo}:}{Object of class \code{"phylo"} that contains a phylogeny.}
    \item{\code{Selection}:}{Object of class \code{"list"} that contains the selection method (along with its statistics) used to select the vectors, the selected vectors IDs and a matrix that contains the selected vectors.}
    \item{\code{PVR}:}{Object of class \code{"list"} that contains the \bold{P}hilogenetic  Eigen\bold{V}ectors \bold{R}egression r squared and residuals.}
    \item{\code{VarPart}:}{Object of class \code{"list"} that contains the variation partition components.}
  }
}
\section{Methods}{
  \describe{
    \item{show}{\code{signature(object = "PVR")}: Always print the \code{Eigen} slot.}
	 }
}
\references{
Diniz-Filho, J.A.F., Sant'Ana, C.E.R. and Bini, L.M. (1998). An eigenvector method for estimating phylogenetic inertia. Evolution 52:1247-1262.

Legendre, P. and Legendre, L. (1998). Numerical ecology, 2nd Englished. Elsevier.

Diniz-filho, J.A.F., Rangel, T.F., Santos, T. and Bini, L.M. (2012). Exploring patterns of interespecific variation in quantitative traits using sequential phylogenetic eigenvector regressions. Evolution, 66(4):1079-1090.

Diniz-filho, J.A.F., Bini, L.M., Rangel, T.F., Morales-Castilla, I., Olalla-Tarraga, M.A., Rodriguez, M.A. and Hawkins, B.A. (2012). On the selection of phylogenetic eigenvectors for ecological analyses. Ecography, 35:239-249.
}
\author{
Santos, T; Diniz-Filho, J.A.F.; Rangel, T.F.; Bini, L.M.
}

\seealso{
\code{\link{PSR-class}}, \code{\link{PVR}}, \code{\link{PSR}},  \code{\link{PVRdecomp}},  \code{\link{PSRplot}},  \code{\link{VarPartplot}}
}
\examples{
showClass("PVR")
}
\keyword{classes}
