% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyDiagnostics.R
\name{shinyDiagnostics}
\alias{shinyDiagnostics}
\title{Create a shiny app summarising your phenotyping results}
\usage{
shinyDiagnostics(
  result,
  directory,
  minCellCount = 5,
  open = rlang::is_interactive(),
  expectations = NULL
)
}
\arguments{
\item{result}{A summarised result}

\item{directory}{Directory where to save report}

\item{minCellCount}{Minimum cell count for suppression when exporting results.}

\item{open}{If TRUE, the shiny app will be launched in a new session. If
FALSE, the shiny app will be created but not launched.}

\item{expectations}{Data frame or tibble with cohort expectations. It must contain the following columns: cohort_name, estimate, value, and source.}
}
\value{
A shiny app
}
\description{
A shiny app that is designed for any diagnostics results from phenotypeR, this
includes:

* A diagnostics on the database via `databaseDiagnostics`.
* A diagnostics on the cohort_codelist attribute of the cohort via `codelistDiagnostics`.
* A diagnostics on the cohort via `cohortDiagnostics`.
* A diagnostics on the population via `populationDiagnostics`.
* A diagnostics on the matched cohort via `matchedDiagnostics`.
}
\examples{
\donttest{
library(PhenotypeR)
library(dplyr)

cdm <- mockPhenotypeR()

result <- phenotypeDiagnostics(cdm$my_cohort)
expectations <- tibble("cohort_name" = rep(c("cohort_1", "cohort_2"),3),
                       "value" = c(rep(c("Mean age"),2),
                                   rep("Male percentage",2),
                                   rep("Survival probability after 5y",2)),
                       "estimate" = c("32", "54", "25\%", "74\%", "95\%", "21\%"),
                       "source" = rep(c("AlbertAI"),6))

shinyDiagnostics(result, tempdir(), expectations = expectations)

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
