% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputFunctions.R
\name{savePheno}
\alias{savePheno}
\title{Save final phenotype and phenotype components.}
\usage{
savePheno(
  simulatedData,
  directory,
  format = ".csv",
  outstring = "",
  saveIntermediate = TRUE,
  intercept_gemma = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{simulatedData}{Named list of i) dataframe of proportion of variance 
explained for each component (varComponents), 
ii) a named list with the final simulated phenotype components 
(phenoComponentsFinal), iii) a named list with the intermediate simulated 
phenotype components (phenoComponentsIntermediate), iv) a named list of 
parameters describing the model setup (setup) and v) a named list of raw 
components (rawComponents) used for genetic effect simulation (genotypes 
and/or kinship); obtained from \link{runSimulation}}

\item{directory}{Absolute path (no tilde expansion) to parent directory 
[string] where simulated data should be saved [needs user writing 
permission]}

\item{format}{Vector of format name(s) [string] specifying the output format;
multiple output formats can be requested. Options are: plink, bimbam, 
snptest, gemma, limmbo, csv or rds. For information on format see details. In
orde to save intermediate phenotype components, at least one of csv or rds
need to be specified. plink/bimbam/snptest will only save final
phenotype/genotype, kinship and covariate data.}

\item{outstring}{Optional name [string] of subdirectory (in relation to 
directory) to save set-up dependent simulation results; if
set to NULL, subdirectory named by NrSamples, NrSNPs, genetic Model and 
noise Model and genVar is created.}

\item{saveIntermediate}{[bool] If TRUE, intermediate phenotype components
such as shared and independent effect components are saved.}

\item{intercept_gemma}{[boolean] When modeling an intercept term in gemma, a 
column of 1's have to be appended to the covariate files. Set intercept_gemma
to TRUE to include a column of 1's in the output; only used when 
"gemma" \%in\% format}

\item{verbose}{[boolean]; If TRUE, progress info is printed to standard out}
}
\value{
Path [string] to final output directory. If outstring is 
NULL, this directory will be a subdirectory of the input directory.
}
\description{
savePheno saves simulated phenotypes and their components, model setup 
parameters and variance components to the specified directories. Requires a 
simulatedData list which is the output of \link{runSimulation}.
}
\examples{
simulatedPhenotype <- runSimulation(N=100, P=5, cNrSNP=10,
genVar=0.2, h2s=0.2, phi=1)
\dontrun{
outputdir <- savePheno(simulatedPhenotype, directory=tempdir(),  
outstring="Data_simulation", format=c("csv", "plink"))}
}
