% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{simulateDist}
\alias{simulateDist}
\title{Data simulation for different distributions.}
\usage{
simulateDist(
  x,
  dist = c("unif", "norm", "bin", "cat_norm", "cat_unif"),
  m = NULL,
  std = 1,
  categories = NULL,
  prob = NULL
)
}
\arguments{
\item{x}{The number [integer] of observations to simulate.}

\item{dist}{Name of distribution [string] from which the observations are 
drawn. 'norm' is the normal distribution, 'unif' the uniform distribution 
'bin' the binomial distribution, "cat_norm" samples categorical variables 
according to a normal distribution and "cat_unif" 
according to a uniform distribution. For "cat_norm", length(category)/2 is 
used mean for the normal distribution unless
specified otherwise.}

\item{m}{Mean of the normal distribution [double]/the mean between min 
and max for the uniform distribution [double]/ 
the rank of the category to be used as mean for "cat_norm" [integer].}

\item{std}{Standard deviation of the normal distribution or the distance 
of min/max from the mean for the uniform distribution [double].}

\item{categories}{Number of categories [integer] for simulating categorical 
variables (for distr="cat_norm" or "cat_unif").}

\item{prob}{Probability [double] of success for each trial 
(for distr="bin").}
}
\value{
Numeric vector of length [x] with the sampled values
}
\description{
Wrapper function to simulate data from different distribution with different 
parameter settings.
}
\examples{
normal <- simulateDist(x=10, dist="norm", m=2, std=4)
cat_normal <- simulateDist(x=10, dist="cat_norm", categories=5)
cat_uniform <- simulateDist(x=10, dist="cat_unif", categories=5)
uniform <- simulateDist(x=10, dist="unif", m=4, std=1)
binomial <- simulateDist(x=10, dist="bin", prob=0.4)
}
\seealso{
\code{\link{runif}}, \code{\link{rnorm}}, \code{\link{rbinom}} for 
documentation of the underlying distributions.
}
